/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.statements.binders;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TypeCodec;
import io.nosqlbench.virtdata.api.bindings.VALUE;
import io.nosqlbench.virtdata.core.bindings.ValuesArrayBinder;
import java.nio.ByteBuffer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsettableValuesBinder
implements ValuesArrayBinder<PreparedStatement, Statement> {
    private static final Logger logger = LoggerFactory.getLogger(UnsettableValuesBinder.class);
    private final Session session;
    private final CodecRegistry codecRegistry;
    private final ProtocolVersion protocolVersion;

    public UnsettableValuesBinder(Session session) {
        this.session = session;
        this.codecRegistry = session.getCluster().getConfiguration().getCodecRegistry();
        this.protocolVersion = this.session.getCluster().getConfiguration().getProtocolOptions().getProtocolVersion();
    }

    @Override
    public Statement bindValues(PreparedStatement preparedStatement, Object[] objects) {
        int i = -1;
        try {
            BoundStatement boundStmt = preparedStatement.bind();
            List<ColumnDefinitions.Definition> defs = preparedStatement.getVariables().asList();
            for (i = 0; i < objects.length; ++i) {
                Object value = objects[i];
                if (VALUE.unset == value) continue;
                if (null == value) {
                    boundStmt.setToNull(i);
                    continue;
                }
                DataType cqlType = defs.get(i).getType();
                TypeCodec<Object> codec = this.codecRegistry.codecFor(cqlType, value);
                ByteBuffer serialized = codec.serialize(value, this.protocolVersion);
                boundStmt.setBytesUnsafe(i, serialized);
            }
            return boundStmt;
        }
        catch (Exception e) {
            String typNam = objects[i] == null ? "NULL" : objects[i].getClass().getCanonicalName();
            logger.error("Error binding column " + preparedStatement.getVariables().asList().get(i).getName() + " with class " + typNam + ": " + e.getMessage(), e);
            throw e;
        }
    }
}

