/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.statements.core;

import io.nosqlbench.activitytype.cql.statements.core.CQLStatementDef;
import io.nosqlbench.activitytype.cql.statements.core.CQLStatementDefParser;
import io.nosqlbench.activitytype.cql.statements.core.TaggedCQLStatementDefs;
import io.nosqlbench.engine.api.util.TagFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AvailableCQLStatements {
    private List<TaggedCQLStatementDefs> availableDefs = new ArrayList<TaggedCQLStatementDefs>();

    public AvailableCQLStatements(List<TaggedCQLStatementDefs> allStatementDef) {
        this.availableDefs = allStatementDef;
    }

    public List<TaggedCQLStatementDefs> getRawTagged() {
        return this.availableDefs;
    }

    public Map<String, String> getFilteringDetails(String tagSpec) {
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>();
        TagFilter ts = new TagFilter(tagSpec);
        for (TaggedCQLStatementDefs availableDef : this.availableDefs) {
            TagFilter.Result result = ts.matchesTaggedResult(availableDef);
            String names = availableDef.getStatements().stream().map(CQLStatementDef::getName).collect(Collectors.joining(","));
            details.put(names, result.getLog());
        }
        return details;
    }

    public List<CQLStatementDefParser> getMatching(String tagSpec) {
        ArrayList defs = new ArrayList();
        TagFilter ts = new TagFilter(tagSpec);
        List<CQLStatementDefParser> CQLStatementDefParsers = this.availableDefs.stream().filter(ts::matchesTagged).map(TaggedCQLStatementDefs::getStatements).flatMap(Collection::stream).map(p -> new CQLStatementDefParser(p.getName(), p.getStatement())).collect(Collectors.toList());
        return CQLStatementDefParsers;
    }

    public List<CQLStatementDefParser> getAll() {
        return this.getMatching("");
    }
}

