/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.statements.core;

import com.datastax.driver.core.ConsistencyLevel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQLStatementDef {
    private static final Logger logger = LoggerFactory.getLogger(CQLStatementDef.class);
    private Map<String, String> params = new HashMap<String, String>();
    private String name = "";
    private String statement = "";
    private boolean prepared = true;
    private String cl = ConsistencyLevel.LOCAL_ONE.name();
    private Map<String, String> bindings = new HashMap<String, String>();

    public String getGenSpec(String s) {
        return this.bindings.get(s);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String statement) {
        this.statement = statement;
    }

    public Map<String, String> getBindings() {
        return this.bindings;
    }

    public void setBindings(Map<String, String> bindings) {
        this.bindings = bindings;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("  name:").append(this.getName()).append("\n");
        sb.append("  statement: |").append("\n");
        String formattedStmt = Arrays.asList(this.getStatement().split("\\r*\n")).stream().map(s -> "    " + s).collect(Collectors.joining("\n"));
        sb.append(formattedStmt);
        if (this.bindings.size() > 0) {
            sb.append("  bindings:\n");
            Optional<Integer> maxLen = this.bindings.keySet().stream().map(String::length).reduce(Integer::max);
            for (String bindName : this.bindings.keySet()) {
                sb.append(String.format("    %-" + (maxLen.orElse(20) + 2) + "s", bindName)).append(" : ").append(this.bindings.get(bindName)).append("\n");
            }
        }
        return sb.toString();
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
    }

    public String getConsistencyLevel() {
        return this.cl;
    }

    public void setConsistencyLevel(String consistencyLevel) {
        this.cl = consistencyLevel;
    }

    public void setCl(String consistencyLevel) {
        this.setConsistencyLevel(consistencyLevel);
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public long getRatio() {
        return Long.parseLong(Optional.ofNullable(this.params.get("ratio")).orElse("1"));
    }
}

