/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.statements.core;

import io.nosqlbench.activitytype.cql.statements.core.CQLStatementDef;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQLStatementDefParser {
    private static final Logger logger = LoggerFactory.getLogger(CQLStatementDefParser.class);
    private static final Pattern stmtToken = Pattern.compile("\\?(\\w+[-_\\d\\w]*)|\\{(\\w+[-_\\d\\w.]*)}");
    private static final String UNSET_VALUE = "UNSET-VALUE";
    private final String stmt;
    private final String name;
    private CQLStatementDef deprecatedDef;
    private Map<String, String> bindings;

    public void setBindings(Map<String, String> bindings) {
        this.bindings = bindings;
    }

    public CQLStatementDef getDeprecatedDef() {
        return this.deprecatedDef;
    }

    public void setDeprecatedDef(CQLStatementDef deprecatedDef) {
        this.deprecatedDef = deprecatedDef;
    }

    public CQLStatementDefParser(String name, String stmt) {
        this.stmt = stmt;
        this.name = name;
        this.bindings = this.bindings;
    }

    public Map<String, String> getBindings() {
        return this.bindings;
    }

    public List<String> getBindableNames() {
        Matcher m = stmtToken.matcher(this.stmt);
        ArrayList<String> bindNames = new ArrayList<String>();
        while (m.find()) {
            String form1 = m.group(1);
            String form2 = m.group(2);
            bindNames.add(form1 != null && !form1.isEmpty() ? form1 : form2);
        }
        return bindNames;
    }

    public String getName() {
        return this.name;
    }

    public String getParsedStatementOrError(Set<String> namedBindings) {
        ParseResult result = this.getParseResult(namedBindings);
        if (result.hasError()) {
            throw new RuntimeException("Statement template has errors:\n" + result.toString());
        }
        return result.getStatement();
    }

    public ParseResult getParseResult(final Set<String> namedBindings) {
        HashSet<String> missingAnchors = new HashSet<String>(){
            {
                this.addAll(namedBindings);
            }
        };
        HashSet<String> missingBindings = new HashSet<String>();
        String statement = this.stmt;
        StringBuilder cooked = new StringBuilder();
        Matcher m = stmtToken.matcher(statement);
        int lastMatch = 0;
        String remainder = "";
        while (m.find(lastMatch)) {
            String pre = statement.substring(lastMatch, m.start());
            String form1 = m.group(1);
            String form2 = m.group(2);
            String tokenName = form1 != null && !form1.isEmpty() ? form1 : form2;
            lastMatch = m.end();
            cooked.append(pre);
            cooked.append("?");
            if (!namedBindings.contains(tokenName)) {
                missingBindings.add(tokenName);
                continue;
            }
            if (!missingAnchors.contains(tokenName)) continue;
            missingAnchors.remove(tokenName);
        }
        if (lastMatch >= 0) {
            cooked.append(statement.substring(lastMatch));
        } else {
            cooked.append(statement);
        }
        logger.info("Parsed statement as: " + cooked.toString().replaceAll("\\n", "\\\\n"));
        return new ParseResult(cooked.toString(), this.name, this.bindings, missingBindings, (Set<String>)missingAnchors);
    }

    public static class ParseResult {
        private Set<String> missingGenerators;
        private Set<String> missingAnchors;
        private String statement;
        private Map<String, String> bindings;
        private String name;

        public ParseResult(String stmt, String name, Map<String, String> bindings, Set<String> missingGenerators, Set<String> missingAnchors) {
            this.missingGenerators = missingGenerators;
            this.missingAnchors = missingAnchors;
            this.statement = stmt;
            this.name = name;
        }

        public String toString() {
            String generatorsSummary = this.missingGenerators.size() > 0 ? "\nundefined generators:" + this.missingGenerators.stream().collect(Collectors.joining(",", "[", "]")) : "";
            return "STMT:" + this.statement + "\n" + generatorsSummary;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getBindings() {
            return this.bindings;
        }

        public boolean hasError() {
            return this.missingGenerators.size() > 0;
        }

        public String getStatement() {
            return this.statement;
        }

        public Set<String> getMissingAnchors() {
            return this.missingAnchors;
        }

        public Set<String> getMissingGenerators() {
            return this.missingGenerators;
        }
    }
}

