/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.statements.core;

import io.nosqlbench.activitytype.cql.statements.core.CQLStatementDefParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CQLStatementGroups {
    private Map<String, List<CQLStatementDefParser>> statementGroups = new HashMap<String, List<CQLStatementDefParser>>();

    public CQLStatementGroups(Map<String, List<CQLStatementDefParser>> statementGroups) {
        this.statementGroups = statementGroups;
    }

    public List<CQLStatementDefParser> getGroups(String ... groupNames) {
        ArrayList<CQLStatementDefParser> statements = new ArrayList<CQLStatementDefParser>();
        for (String groupName : groupNames) {
            List adding = this.statementGroups.getOrDefault(groupName, Collections.emptyList());
            statements.addAll(adding);
        }
        return statements;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> groups = new ArrayList<String>(this.statementGroups.keySet());
        Collections.sort(groups);
        sb.append("groups:\n");
        for (String group : groups) {
            for (CQLStatementDefParser statementDef : this.statementGroups.get(group)) {
                sb.append(statementDef.toString());
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

