/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.statements.core;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Timer;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import io.nosqlbench.activitytype.cql.api.ResultSetCycleOperator;
import io.nosqlbench.activitytype.cql.api.RowCycleOperator;
import io.nosqlbench.virtdata.core.bindings.ContextualArrayBindings;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.TimeUnit;

public class ReadyCQLStatement {
    private String name;
    private ContextualArrayBindings<?, Statement> contextualBindings;
    private long ratio;
    private ResultSetCycleOperator[] resultSetOperators = null;
    private RowCycleOperator[] rowCycleOperators = null;
    private Timer successTimer;
    private Timer errorTimer;
    private Histogram rowsFetchedHisto;
    private Writer resultCsvWriter;

    public ReadyCQLStatement(ContextualArrayBindings<?, Statement> contextualBindings, long ratio, String name) {
        this.contextualBindings = contextualBindings;
        this.ratio = ratio;
        this.name = name;
    }

    public ReadyCQLStatement withMetrics(Timer successTimer, Timer errorTimer, Histogram rowsFetchedHisto) {
        this.successTimer = successTimer;
        this.errorTimer = errorTimer;
        this.rowsFetchedHisto = rowsFetchedHisto;
        return this;
    }

    public Statement bind(long value) {
        return this.contextualBindings.bind(value);
    }

    public ResultSetCycleOperator[] getResultSetOperators() {
        return this.resultSetOperators;
    }

    public ContextualArrayBindings getContextualBindings() {
        return this.contextualBindings;
    }

    public String getQueryString(long value) {
        Object stmt = this.contextualBindings.getContext();
        if (stmt instanceof PreparedStatement) {
            String queryString = ((PreparedStatement)stmt).getQueryString();
            StringBuilder sb = new StringBuilder(queryString.length() * 2);
            sb.append("(prepared) ");
            return this.getQueryStringValues(value, queryString, sb);
        }
        if (stmt instanceof SimpleStatement) {
            String queryString = ((SimpleStatement)stmt).getQueryString();
            StringBuilder sb = new StringBuilder();
            sb.append("(simple) ");
            return this.getQueryStringValues(value, queryString, sb);
        }
        if (stmt instanceof String) {
            return (String)stmt;
        }
        throw new RuntimeException("context object not recognized for query string:" + stmt.getClass().getCanonicalName());
    }

    private String getQueryStringValues(long value, String queryString, StringBuilder sb) {
        if (!queryString.endsWith("\n")) {
            sb.append("\n");
        }
        sb.append(queryString).append(" VALUES[");
        Object[] all = this.contextualBindings.getBindings().getAll(value);
        String delim = "";
        for (Object o : all) {
            sb.append(delim);
            delim = ",";
            sb.append(o.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public long getRatio() {
        return this.ratio;
    }

    public void setRatio(long ratio) {
        this.ratio = ratio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess(long cycleValue, long nanoTime, long rowsFetched) {
        if (this.successTimer != null) {
            this.successTimer.update(nanoTime, TimeUnit.NANOSECONDS);
        }
        if (this.rowsFetchedHisto != null) {
            this.rowsFetchedHisto.update(rowsFetched);
        }
        if (this.resultCsvWriter != null) {
            try {
                Writer writer = this.resultCsvWriter;
                synchronized (writer) {
                    this.resultCsvWriter.append(String.valueOf(cycleValue)).append(",").append("SUCCESS,").append(String.valueOf(nanoTime)).append(",").append(String.valueOf(rowsFetched)).append(",NONE").append("\n");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(long cycleValue, long resultNanos, Throwable t) {
        if (this.errorTimer != null) {
            this.errorTimer.update(resultNanos, TimeUnit.NANOSECONDS);
        }
        if (this.resultCsvWriter != null) {
            try {
                Writer writer = this.resultCsvWriter;
                synchronized (writer) {
                    this.resultCsvWriter.append(String.valueOf(cycleValue)).append(",").append("FAILURE,").append(String.valueOf(resultNanos)).append(",").append("0,").append(t.getClass().getSimpleName()).append(",").append("\n");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ReadyCQLStatement withResultSetCycleOperators(ResultSetCycleOperator[] resultSetCycleOperators) {
        this.resultSetOperators = resultSetCycleOperators;
        return this;
    }

    public ReadyCQLStatement withRowCycleOperators(RowCycleOperator[] rowCycleOperators) {
        this.rowCycleOperators = rowCycleOperators;
        return this;
    }

    public RowCycleOperator[] getRowCycleOperators() {
        return this.rowCycleOperators;
    }

    public ReadyCQLStatement withResultCsvWriter(Writer resultCsvWriter) {
        this.resultCsvWriter = resultCsvWriter;
        return this;
    }
}

