/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.statements.core;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Timer;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import io.nosqlbench.activitytype.cql.api.ResultSetCycleOperator;
import io.nosqlbench.activitytype.cql.api.RowCycleOperator;
import io.nosqlbench.activitytype.cql.core.CqlActivity;
import io.nosqlbench.activitytype.cql.statements.binders.CqlBinderTypes;
import io.nosqlbench.activitytype.cql.statements.binders.SimpleStatementValuesBinder;
import io.nosqlbench.activitytype.cql.statements.core.ReadyCQLStatement;
import io.nosqlbench.engine.api.metrics.ActivityMetrics;
import io.nosqlbench.virtdata.core.bindings.BindingsTemplate;
import io.nosqlbench.virtdata.core.bindings.ContextualBindingsArrayTemplate;
import io.nosqlbench.virtdata.core.bindings.ValuesArrayBinder;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadyCQLStatementTemplate {
    private static final Logger logger = LoggerFactory.getLogger(ReadyCQLStatementTemplate.class);
    private final Session session;
    private ContextualBindingsArrayTemplate<?, Statement> template;
    private long ratio;
    private String name;
    private ResultSetCycleOperator[] resultSetCycleOperators;
    private RowCycleOperator[] rowCycleOperators;
    private Timer successTimer;
    private Timer errorTimer;
    private Histogram rowsFetchedHisto;
    private Writer resultCsvWriter;

    public ReadyCQLStatementTemplate(Map<String, Object> fconfig, CqlBinderTypes binderType, Session session, PreparedStatement preparedStmt, long ratio, String name) {
        this.session = session;
        this.name = name;
        ValuesArrayBinder<PreparedStatement, Statement> binder = binderType.get(session);
        logger.trace("Using binder_type=>" + binder.toString());
        this.template = new ContextualBindingsArrayTemplate<PreparedStatement, Statement>(preparedStmt, new BindingsTemplate(fconfig), binder);
        this.ratio = ratio;
    }

    public ReadyCQLStatementTemplate(Map<String, Object> fconfig, Session session, SimpleStatement simpleStatement, long ratio, String name, boolean parametrized) {
        this.session = session;
        this.name = name;
        this.template = new ContextualBindingsArrayTemplate<SimpleStatement, Statement>(simpleStatement, new BindingsTemplate(fconfig), new SimpleStatementValuesBinder(parametrized));
        this.ratio = ratio;
    }

    public ReadyCQLStatement resolve() {
        return new ReadyCQLStatement(this.template.resolveBindings(), this.ratio, this.name).withMetrics(this.successTimer, this.errorTimer, this.rowsFetchedHisto).withResultSetCycleOperators(this.resultSetCycleOperators).withRowCycleOperators(this.rowCycleOperators).withResultCsvWriter(this.resultCsvWriter);
    }

    public ContextualBindingsArrayTemplate<?, Statement> getContextualBindings() {
        return this.template;
    }

    public String getName() {
        return this.name;
    }

    public void instrument(CqlActivity activity) {
        this.successTimer = ActivityMetrics.timer(activity.getActivityDef(), this.name + "--success");
        this.errorTimer = ActivityMetrics.timer(activity.getActivityDef(), this.name + "--error");
        this.rowsFetchedHisto = ActivityMetrics.histogram(activity.getActivityDef(), this.name + "--resultset-size");
    }

    public void logResultCsv(CqlActivity activity, String name) {
        this.resultCsvWriter = activity.getNamedWriter(name);
    }

    public void addResultSetOperators(ResultSetCycleOperator ... addingOperators) {
        this.resultSetCycleOperators = this.resultSetCycleOperators == null ? new ResultSetCycleOperator[]{} : this.resultSetCycleOperators;
        ResultSetCycleOperator[] newOperators = new ResultSetCycleOperator[this.resultSetCycleOperators.length + addingOperators.length];
        System.arraycopy(this.resultSetCycleOperators, 0, newOperators, 0, this.resultSetCycleOperators.length);
        System.arraycopy(addingOperators, 0, newOperators, this.resultSetCycleOperators.length, addingOperators.length);
        this.resultSetCycleOperators = newOperators;
    }

    public void addRowCycleOperators(RowCycleOperator ... addingOperators) {
        this.rowCycleOperators = this.rowCycleOperators == null ? new RowCycleOperator[]{} : this.rowCycleOperators;
        RowCycleOperator[] newOperators = new RowCycleOperator[this.rowCycleOperators.length + addingOperators.length];
        System.arraycopy(this.rowCycleOperators, 0, newOperators, 0, this.rowCycleOperators.length);
        System.arraycopy(addingOperators, 0, newOperators, this.rowCycleOperators.length, addingOperators.length);
        this.rowCycleOperators = newOperators;
    }
}

