/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.statements.core;

import io.nosqlbench.activitytype.cql.statements.core.AvailableCQLStatements;
import io.nosqlbench.activitytype.cql.statements.core.CQLStatementDef;
import io.nosqlbench.activitytype.cql.statements.core.TaggedCQLStatementDefs;
import io.nosqlbench.engine.api.activityimpl.ActivityInitializationError;
import io.nosqlbench.nb.api.content.Content;
import io.nosqlbench.nb.api.content.NBIO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;

public class YamlCQLStatementLoader {
    private static final Logger logger = LoggerFactory.getLogger(YamlCQLStatementLoader.class);
    List<Function<String, String>> transformers = new ArrayList<Function<String, String>>();

    public YamlCQLStatementLoader() {
    }

    public YamlCQLStatementLoader(Function<String, String> ... transformers) {
        this.transformers.addAll(Arrays.asList(transformers));
    }

    public AvailableCQLStatements load(String fromPath, String ... searchPaths) {
        Content<?> yamlContent = NBIO.all().prefix(searchPaths).name(fromPath).extension("yaml").one();
        String data = yamlContent.asString();
        for (Function<String, String> xform : this.transformers) {
            try {
                logger.debug("Applying string transformer to yaml data:" + xform);
                data = xform.apply(data);
            }
            catch (Exception e) {
                ActivityInitializationError t = new ActivityInitializationError("Error applying string transform to input", e);
                logger.error(t.getMessage(), t);
                throw t;
            }
        }
        Yaml yaml = this.getCustomYaml();
        try {
            Iterable<Object> objects = yaml.loadAll(data);
            ArrayList<TaggedCQLStatementDefs> stmtListList = new ArrayList<TaggedCQLStatementDefs>();
            for (Object object : objects) {
                TaggedCQLStatementDefs tsd = (TaggedCQLStatementDefs)object;
                stmtListList.add(tsd);
            }
            return new AvailableCQLStatements(stmtListList);
        }
        catch (Exception e) {
            logger.error("Error loading yaml from " + fromPath, e);
            throw e;
        }
    }

    private Yaml getCustomYaml() {
        Constructor constructor = new Constructor(TaggedCQLStatementDefs.class);
        TypeDescription tds = new TypeDescription(TaggedCQLStatementDefs.class);
        tds.putListPropertyType("statements", CQLStatementDef.class);
        constructor.addTypeDescription(tds);
        return new Yaml(constructor);
    }
}

