/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.statements.rsoperators;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import io.nosqlbench.activitytype.cql.api.ResultSetCycleOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlResultSetLogger
implements ResultSetCycleOperator {
    private static final Logger logger = LoggerFactory.getLogger(CqlResultSetLogger.class);

    private static String getQueryString(Statement stmt) {
        if (stmt instanceof PreparedStatement) {
            return "(prepared) " + ((PreparedStatement)((Object)stmt)).getQueryString();
        }
        if (stmt instanceof SimpleStatement) {
            return "(simple) " + ((SimpleStatement)stmt).getQueryString();
        }
        if (stmt instanceof BoundStatement) {
            return "(bound) " + ((BoundStatement)stmt).preparedStatement().getQueryString();
        }
        return "(unknown) " + stmt.toString();
    }

    @Override
    public int apply(ResultSet resultSet, Statement statement, long cycle) {
        logger.debug("result-set-logger:  cycle=" + cycle + " rows=" + resultSet.getAvailableWithoutFetching() + " fetched=" + resultSet.isFullyFetched() + " statement=" + CqlResultSetLogger.getQueryString(statement).stripTrailing());
        for (Row row : resultSet) {
            logger.trace(row.toString());
        }
        return 0;
    }
}

