/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.docsys.core;

import io.nosqlbench.docsys.core.DocServer;
import io.nosqlbench.docsys.core.DocsysMarkdownEndpoint;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DocServerApp {
    public static final String APPNAME_DOCSERVER = "docserver";
    private static Logger logger = LogManager.getLogger(DocServerApp.class);

    public static void main(String[] args) {
        if (args.length > 0 && args[0].contains("help")) {
            DocServerApp.showHelp(new String[0]);
        } else if (args.length > 0 && args[0].contains("generate")) {
            try {
                String[] genargs = Arrays.copyOfRange(args, 1, args.length);
                logger.info("Generating with args [" + String.join((CharSequence)"][", args) + "]");
                DocServerApp.generate(genargs);
            }
            catch (IOException e) {
                logger.error("could not generate files with command " + String.join((CharSequence)" ", args));
                e.printStackTrace();
            }
        } else {
            DocServerApp.runServer(args);
        }
    }

    private static boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                DocServerApp.deleteDirectory(file);
            }
        }
        return directoryToBeDeleted.delete();
    }

    private static void generate(String[] args) throws IOException {
        String[] markdownFileArray;
        Path dirpath = args.length == 0 ? Path.of("docs", new String[0]) : Path.of(args[0], new String[0]);
        OpenOption[] OVERWRITE = new StandardOpenOption[]{StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.WRITE};
        logger.info("generating to directory " + dirpath.toString());
        DocsysMarkdownEndpoint dds = new DocsysMarkdownEndpoint();
        String markdownList = dds.getMarkdownList(true);
        Path markdownCsvPath = dirpath.resolve(Path.of("services/docs/markdown.csv", new String[0]));
        logger.info("markdown.csv located at " + markdownCsvPath.toString());
        Files.createDirectories(markdownCsvPath.getParent(), new FileAttribute[0]);
        Files.writeString(markdownCsvPath, (CharSequence)markdownList, OVERWRITE);
        for (String markdownFile : markdownFileArray = markdownList.split("\n")) {
            Path relativePath = dirpath.resolve(Path.of("services/docs/markdown", markdownFile));
            logger.info("Creating " + relativePath.toString());
            String markdown = dds.getFileByPath(markdownFile);
            Files.createDirectories(relativePath.getParent(), new FileAttribute[0]);
            Files.writeString(relativePath, (CharSequence)markdown, OVERWRITE);
        }
    }

    private static void runServer(String[] serverArgs) {
        DocServer server = new DocServer();
        for (int i = 0; i < serverArgs.length; ++i) {
            String arg = serverArgs[i];
            if (arg.matches(".*://.*")) {
                if (!arg.toLowerCase().contains("http://")) {
                    String suggested = arg.toLowerCase().replaceAll("https", "http");
                    throw new RuntimeException("ERROR:\nIn this release, only 'http://' URLs are supported.\nTLS will be added in a future release.\nSee https://github.com/nosqlbench/nosqlbench/issues/35\nConsider using " + suggested);
                }
                server.withURL(arg);
                continue;
            }
            if (Files.exists(Path.of(arg, new String[0]), new LinkOption[0])) {
                server.addPaths(Path.of(arg, new String[0]));
                continue;
            }
            if (arg.matches("\\d+")) {
                server.withPort(Integer.parseInt(arg));
                continue;
            }
            if (!arg.matches("--public")) continue;
            server.withHost("0.0.0.0");
        }
        server.run();
    }

    private static void showHelp(String ... helpArgs) {
        System.out.println("Usage: docserver  [url]  [path]... \n\nIf [url] is provided, then the scheme, address and port are all taken from it.\nAny additional paths are served from the filesystem, in addition to the internal ones.\n\nFor now, only http:// is supported.");
    }

    private static void search(String[] searchArgs) {
    }

    private static void listTopics() {
    }
}

