/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.core.ops.fluent;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import io.nosqlbench.engine.api.activityapi.core.Activity;
import io.nosqlbench.engine.api.activityapi.core.ActivityDefObserver;
import io.nosqlbench.engine.api.activityapi.core.ops.fluent.OpTracker;
import io.nosqlbench.engine.api.activityapi.core.ops.fluent.opfacets.EventedOpImpl;
import io.nosqlbench.engine.api.activityapi.core.ops.fluent.opfacets.FailedOp;
import io.nosqlbench.engine.api.activityapi.core.ops.fluent.opfacets.OpEvents;
import io.nosqlbench.engine.api.activityapi.core.ops.fluent.opfacets.SkippedOp;
import io.nosqlbench.engine.api.activityapi.core.ops.fluent.opfacets.StartedOp;
import io.nosqlbench.engine.api.activityapi.core.ops.fluent.opfacets.SucceededOp;
import io.nosqlbench.engine.api.activityapi.core.ops.fluent.opfacets.TrackedOp;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongFunction;

public class OpTrackerImpl<D>
implements OpTracker<D>,
ActivityDefObserver {
    private final AtomicInteger pendingOps = new AtomicInteger(0);
    private final String label;
    private final long slot;
    private final Timer cycleServiceTimer;
    private final Timer cycleResponseTimer;
    private final Counter pendingOpsCounter;
    private int maxPendingOps = 1;
    private LongFunction<D> cycleOpFunction;

    public OpTrackerImpl(Activity activity, long slot) {
        this.slot = slot;
        this.label = "tracker-" + slot + "_" + activity.getAlias();
        this.pendingOpsCounter = activity.getInstrumentation().getOrCreatePendingOpCounter();
        this.cycleServiceTimer = activity.getInstrumentation().getOrCreateCyclesServiceTimer();
        this.cycleResponseTimer = activity.getInstrumentation().getCyclesResponseTimerOrNull();
    }

    public OpTrackerImpl(String name, int slot, Timer cycleServiceTimer, Timer cycleResponseTimer, Counter pendingOpsCounter) {
        this.label = name;
        this.slot = slot;
        this.cycleResponseTimer = cycleResponseTimer;
        this.cycleServiceTimer = cycleServiceTimer;
        this.pendingOpsCounter = pendingOpsCounter;
    }

    @Override
    public void onOpStarted(StartedOp<D> op) {
        this.pendingOps.incrementAndGet();
        this.pendingOpsCounter.inc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOpSuccess(SucceededOp<D> op) {
        this.pendingOpsCounter.dec();
        int pending = this.pendingOps.decrementAndGet();
        this.cycleServiceTimer.update(op.getServiceTimeNanos(), TimeUnit.NANOSECONDS);
        if (this.cycleResponseTimer != null) {
            this.cycleResponseTimer.update(op.getResponseTimeNanos(), TimeUnit.NANOSECONDS);
        }
        if (pending < this.maxPendingOps) {
            OpTrackerImpl opTrackerImpl = this;
            synchronized (opTrackerImpl) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOpSkipped(SkippedOp<D> op) {
        this.pendingOpsCounter.dec();
        int pending = this.pendingOps.decrementAndGet();
        if (pending < this.maxPendingOps) {
            OpTrackerImpl opTrackerImpl = this;
            synchronized (opTrackerImpl) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOpFailure(FailedOp<D> op) {
        this.pendingOpsCounter.dec();
        int pending = this.pendingOps.decrementAndGet();
        this.cycleServiceTimer.update(op.getServiceTimeNanos(), TimeUnit.NANOSECONDS);
        if (this.cycleResponseTimer != null) {
            this.cycleResponseTimer.update(op.getResponseTimeNanos(), TimeUnit.NANOSECONDS);
        }
        if (pending < this.maxPendingOps) {
            OpTrackerImpl opTrackerImpl = this;
            synchronized (opTrackerImpl) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxPendingOps(int maxPendingOps) {
        this.maxPendingOps = maxPendingOps;
        OpTrackerImpl opTrackerImpl = this;
        synchronized (opTrackerImpl) {
            this.notifyAll();
        }
    }

    @Override
    public boolean isFull() {
        return this.pendingOps.intValue() >= this.maxPendingOps;
    }

    @Override
    public int getPendingOps() {
        return this.pendingOps.intValue();
    }

    @Override
    public void setCycleOpFunction(LongFunction<D> newOpFunction) {
        this.cycleOpFunction = newOpFunction;
    }

    @Override
    public TrackedOp<D> newOp(long cycle, OpEvents<D> strideTracker) {
        D opstate = this.cycleOpFunction.apply(cycle);
        EventedOpImpl<D> op = new EventedOpImpl<D>(this, strideTracker);
        op.setCycle(cycle);
        op.setData(opstate);
        return op;
    }

    @Override
    public int getMaxPendingOps() {
        return this.maxPendingOps;
    }

    @Override
    public synchronized boolean awaitCompletion(long timeout) {
        long endAt = System.currentTimeMillis() + timeout;
        while (this.getPendingOps() > 0 && System.currentTimeMillis() < endAt) {
            try {
                long waitfor = Math.max(0L, endAt - System.currentTimeMillis());
                this.wait(waitfor);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.getPendingOps() == 0;
    }

    public String toString() {
        return "OpTracker-" + this.label + ":" + this.slot + " " + this.pendingOps.get() + "/" + this.maxPendingOps + " ops ";
    }

    @Override
    public void onActivityDefUpdate(ActivityDef activityDef) {
        this.maxPendingOps = this.getMaxPendingOpsForThisThread(activityDef);
    }

    private int getMaxPendingOpsForThisThread(ActivityDef def) {
        int maxTotalOpsInFlight = def.getParams().getOptionalInteger("async").orElse(1);
        int threads = def.getThreads();
        return maxTotalOpsInFlight / threads + (this.slot < (long)(maxTotalOpsInFlight % threads) ? 1 : 0);
    }
}

