/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results;

import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.CycleResult;
import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.CycleResultsSegment;
import io.nosqlbench.engine.api.activityapi.cyclelog.outputs.CanSortCycles;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CycleResultArray
implements CycleResultsSegment,
CanSortCycles {
    private CycleResult[] cycleResults;

    public CycleResultArray(CycleResult[] cycleResults) {
        this.cycleResults = cycleResults;
    }

    public CycleResultArray(CycleResultsSegment segment) {
        this.cycleResults = new CycleResult[(int)segment.getCount()];
        Iterator iterator = segment.iterator();
        for (int i = 0; i < this.cycleResults.length; ++i) {
            this.cycleResults[i] = (CycleResult)iterator.next();
        }
    }

    @Override
    public long getCount() {
        return this.cycleResults.length;
    }

    @Override
    public long getMinCycle() {
        return this.cycleResults[0].getCycle();
    }

    @Override
    public Iterator<CycleResult> iterator() {
        return new CycleResultArrayIterator(this.cycleResults);
    }

    @Override
    public void sort() {
        Arrays.sort(this.cycleResults);
    }

    private static class CycleResultArrayIterator
    implements Iterator<CycleResult> {
        private final CycleResult[] results;
        private int idx;

        public CycleResultArrayIterator(CycleResult[] results) {
            this.results = results;
            this.idx = 0;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.results.length;
        }

        @Override
        public CycleResult next() {
            if (this.idx >= this.results.length) {
                throw new NoSuchElementException("Unable to read array past last value");
            }
            CycleResult result = this.results[this.idx];
            ++this.idx;
            return result;
        }
    }
}

