/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results_rle;

import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.CycleResult;
import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.ResultReadable;
import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results_rle.CycleResultsRLEBufferReadable;
import io.nosqlbench.engine.api.activityapi.cyclelog.inputs.cyclelog.CanFilterResultValue;
import io.nosqlbench.engine.api.activityapi.output.Output;
import java.nio.ByteBuffer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CycleResultsRLEBufferTarget
implements Output,
CanFilterResultValue {
    private static final Logger logger = LoggerFactory.getLogger(CycleResultsRLEBufferTarget.class);
    public static final int BYTES = 17;
    private ByteBuffer buf;
    private long lastCycle = Long.MIN_VALUE;
    private long lastResult = Integer.MIN_VALUE;
    private long runlength = 0L;
    private boolean flushed = false;
    private long count = 0L;
    private long min = Long.MAX_VALUE;
    private Predicate<ResultReadable> filter;

    public CycleResultsRLEBufferTarget(ByteBuffer buf) {
        this.buf = buf;
    }

    public CycleResultsRLEBufferTarget(int elementCount) {
        this(ByteBuffer.allocate(elementCount * 17));
    }

    public CycleResultsRLEBufferReadable toSegmentsReadable() {
        this.flush();
        ByteBuffer readable = this.buf.duplicate();
        readable.flip();
        return new CycleResultsRLEBufferReadable(readable);
    }

    public ByteBuffer toByteBuffer() {
        this.flush();
        ByteBuffer bb = this.buf.duplicate();
        bb.flip();
        return bb;
    }

    @Override
    public boolean onCycleResult(long cycle, int result) {
        ResultReadableWrapper resultReadableWrapper = new ResultReadableWrapper(result);
        if (this.filter != null && !this.filter.test(resultReadableWrapper)) {
            return true;
        }
        if ((cycle != this.lastCycle + 1L || this.lastResult != (long)result) && this.lastCycle != Long.MIN_VALUE) {
            this.checkpoint(this.lastCycle + 1L - this.runlength, this.lastCycle + 1L, this.lastResult);
        }
        this.lastCycle = cycle;
        this.lastResult = result;
        ++this.runlength;
        this.flushed = false;
        return true;
    }

    private void checkpoint(long istart, long iend, long lastResult) {
        if (this.buf.remaining() == 0) {
            this.buf = this.resize(this.buf);
        }
        if (lastResult > 127L) {
            throw new RuntimeException("Unable to encode result values greater than Byte.MAX_VALUE.");
        }
        if (this.lastCycle >= 0L) {
            this.buf.putLong(istart).putLong(iend).put((byte)lastResult);
            this.runlength = 0L;
            return;
        }
        if (this.lastCycle != Long.MIN_VALUE) {
            throw new RuntimeException("Unable to encode cycle values less than 0");
        }
        logger.trace("checkpoint with no active RLE segment data.");
    }

    private ByteBuffer resize(ByteBuffer buf) {
        ByteBuffer doubled = ByteBuffer.allocate(buf.capacity() * 2);
        buf.flip();
        doubled.put(buf);
        logger.warn("resized buffer to " + doubled + " to ensure capacity.");
        return doubled;
    }

    public int getRawBufferCapacity() {
        return this.buf.capacity();
    }

    public int getRecordCapacity() {
        return this.buf.capacity() / 17;
    }

    private int flush() {
        if (!this.flushed) {
            this.checkpoint(this.lastCycle + 1L - this.runlength, this.lastCycle + 1L, this.lastResult);
            this.flushed = true;
        }
        return this.buf.position();
    }

    @Override
    public void close() {
        this.flush();
    }

    @Override
    public boolean onCycleResult(CycleResult cycleResult) {
        return this.onCycleResult(cycleResult.getCycle(), cycleResult.getResult());
    }

    @Override
    public void setFilter(Predicate<ResultReadable> filter) {
        this.filter = filter;
    }

    private static class ResultReadableWrapper
    implements ResultReadable {
        private int result;

        ResultReadableWrapper(int result) {
            this.result = result;
        }

        @Override
        public int getResult() {
            return this.result;
        }
    }
}

