/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.cyclelog.outputs;

import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.CycleResultArray;
import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.CycleResultsSegment;
import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.CycleResultsSegmentReadable;
import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.ResultReadable;
import io.nosqlbench.engine.api.activityapi.cyclelog.inputs.cyclelog.CanFilterResultValue;
import io.nosqlbench.engine.api.activityapi.cyclelog.outputs.CanSortCycles;
import io.nosqlbench.engine.api.activityapi.output.Output;
import java.util.Collections;
import java.util.LinkedList;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReorderingConcurrentResultBuffer
implements Output,
CanFilterResultValue {
    private static final Logger logger = LoggerFactory.getLogger(ReorderingConcurrentResultBuffer.class);
    private LinkedList<CycleResultsSegment> segments = new LinkedList();
    private Output downstream;
    private final int threshold;
    private int currentCount;
    private int segmentCount;
    private Predicate<ResultReadable> resultFilter;

    public ReorderingConcurrentResultBuffer(Output downstream) {
        this(downstream, 1000);
    }

    public ReorderingConcurrentResultBuffer(Output downstream, int threshold) {
        this.downstream = downstream;
        this.threshold = threshold;
    }

    @Override
    public synchronized boolean onCycleResult(long completedCycle, int result) {
        this.onCycleResultSegment(CycleResultsSegmentReadable.forCycleResult(completedCycle, result));
        return true;
    }

    @Override
    public synchronized void onCycleResultSegment(CycleResultsSegment segment) {
        if (this.resultFilter != null) {
            segment = segment.filter(this.resultFilter);
        }
        if (!(segment instanceof CanSortCycles)) {
            segment = new CycleResultArray(segment);
        }
        ((CanSortCycles)((Object)segment)).sort();
        this.segments.add(segment);
        ++this.segmentCount;
        this.currentCount = (int)((long)this.currentCount + segment.getCount());
        if (this.currentCount >= this.threshold) {
            logger.trace("Reordering threshold met: " + this.currentCount + "/" + this.threshold + ", sorting and pushing. (" + this.segments.size() + " segments)");
            Collections.sort(this.segments);
            while (this.currentCount >= this.threshold) {
                CycleResultsSegment head = this.segments.removeFirst();
                this.downstream.onCycleResultSegment(head);
                --this.segmentCount;
                this.currentCount = (int)((long)this.currentCount - head.getCount());
            }
        }
    }

    @Override
    public synchronized void close() throws Exception {
        logger.trace("closing and flushing " + this.segments.size() + " segments");
        Collections.sort(this.segments);
        for (CycleResultsSegment segment : this.segments) {
            this.downstream.onCycleResultSegment(segment);
            --this.segmentCount;
            this.currentCount = (int)((long)this.currentCount - segment.getCount());
        }
        this.downstream.close();
    }

    @Override
    public void setFilter(Predicate<ResultReadable> filter) {
        this.resultFilter = filter;
    }
}

