/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.cyclelog.outputs.cyclelog;

import io.nosqlbench.engine.api.activityapi.core.Activity;
import io.nosqlbench.engine.api.activityapi.cyclelog.outputs.ReorderingConcurrentResultBuffer;
import io.nosqlbench.engine.api.activityapi.cyclelog.outputs.cyclelog.CycleLogOutput;
import io.nosqlbench.engine.api.activityapi.input.Input;
import io.nosqlbench.engine.api.activityapi.output.Output;
import io.nosqlbench.engine.api.activityapi.output.OutputDispenser;
import io.nosqlbench.engine.api.activityapi.output.OutputType;
import io.nosqlbench.nb.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value=OutputType.class)
public class CycleLogOutputType
implements OutputType {
    @Override
    public String getName() {
        return "cyclelog";
    }

    @Override
    public OutputDispenser getOutputDispenser(Activity activity) {
        return new Dispenser(activity);
    }

    public static class Dispenser
    implements OutputDispenser {
        private static final Logger logger = LoggerFactory.getLogger(OutputDispenser.class);
        private final Output output;
        private Activity activity;

        public Dispenser(Activity activity) {
            this.activity = activity;
            Input input = activity.getInputDispenserDelegate().getInput(0L);
            CycleLogOutput rleFileWriter = new CycleLogOutput(activity);
            logger.debug("pre-buffering output extents with best-effort before RLE buffering");
            ReorderingConcurrentResultBuffer prebuffer = new ReorderingConcurrentResultBuffer(rleFileWriter);
            this.output = prebuffer;
            activity.registerAutoCloseable(this.output);
        }

        @Override
        public Output getOutput(long slot) {
            return this.output;
        }
    }
}

