/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.planning;

import io.nosqlbench.engine.api.activityapi.planning.ElementSequencer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;

public class BucketSequencer<T>
implements ElementSequencer<T> {
    private List<T> elems;
    private ToLongFunction<T> ratioFunc;

    @Override
    public int[] seqIndexByRatioFunc(List<T> elems, ToLongFunction<T> ratioFunc) {
        ArrayList<Long> ratios = new ArrayList<Long>();
        for (int i = 0; i < elems.size(); ++i) {
            T elem = elems.get(i);
            ratios.add(ratioFunc.applyAsLong(elem));
        }
        return this.seqIndexesByRatios(elems, ratios);
    }

    @Override
    public int[] seqIndexesByRatios(List<T> elems, List<Long> ratios) {
        List<OpBucket<Object>> buckets = new ArrayList<OpBucket<T>>();
        ArrayList sequence = new ArrayList();
        if (elems.size() != ratios.size()) {
            throw new RuntimeException("Elements and Ratios must be pair-wise.");
        }
        for (int i2 = 0; i2 < elems.size(); ++i2) {
            T elem = elems.get(i2);
            long ratio = ratios.get(i2);
            if (ratio <= 0L) continue;
            buckets.add(new OpBucket<T>(elem, i2, ratio));
        }
        while (!buckets.isEmpty()) {
            buckets.forEach(b -> sequence.add(b.dispenseRank()));
            buckets = buckets.stream().filter(b -> b.count > 0L).collect(Collectors.toCollection(LinkedList::new));
        }
        return sequence.stream().mapToInt(i -> i).toArray();
    }

    private static final class OpBucket<T> {
        private final int rank;
        private T elem;
        private long count;

        OpBucket(T elem, int rank, long ratio) {
            this.elem = elem;
            this.rank = rank;
            this.count = ratio;
        }

        public boolean isEmpty() {
            return this.count == 0L;
        }

        int dispenseRank() {
            --this.count;
            return this.rank;
        }
    }
}

