/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.planning;

import io.nosqlbench.engine.api.activityapi.planning.BucketSequencer;
import io.nosqlbench.engine.api.activityapi.planning.ConcatSequencer;
import io.nosqlbench.engine.api.activityapi.planning.IntervalSequencer;
import io.nosqlbench.engine.api.activityapi.planning.OpSequence;
import io.nosqlbench.engine.api.activityapi.planning.SequencerType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequencePlanner<T> {
    private static final Logger logger = LoggerFactory.getLogger(SequencePlanner.class);
    private SequencerType sequencerType;
    private List<T> elements = new ArrayList<T>();
    private List<Long> ratios = new ArrayList<Long>();
    private int[] elementIndex;

    public SequencePlanner(SequencerType sequencerType) {
        this.sequencerType = sequencerType;
    }

    public void addOp(T elem, ToLongFunction<T> ratioFunc) {
        this.elements.add(elem);
        this.ratios.add(ratioFunc.applyAsLong(elem));
    }

    public void addOp(T elem, long func) {
        this.elements.add(elem);
        this.ratios.add(func);
    }

    public OpSequence<T> resolve() {
        switch (this.sequencerType) {
            case bucket: {
                logger.trace("sequencing elements by simple round-robin");
                this.elementIndex = new BucketSequencer<T>().seqIndexesByRatios(this.elements, this.ratios);
                break;
            }
            case interval: {
                logger.trace("sequencing elements by interval and position");
                this.elementIndex = new IntervalSequencer<T>().seqIndexesByRatios(this.elements, this.ratios);
                break;
            }
            case concat: {
                logger.trace("sequencing elements by concatenation");
                this.elementIndex = new ConcatSequencer<T>().seqIndexesByRatios(this.elements, this.ratios);
            }
        }
        this.elements = this.elements;
        return new Sequence<T>(this.sequencerType, this.elements, this.elementIndex);
    }

    public static class Sequence<T>
    implements OpSequence<T> {
        private final SequencerType type;
        private final List<T> elems;
        private final int[] seq;

        Sequence(SequencerType type, List<T> elems, int[] seq) {
            this.type = type;
            this.elems = elems;
            this.seq = seq;
        }

        @Override
        public T get(long selector) {
            int index = (int)(selector % (long)this.seq.length);
            index = this.seq[index];
            return this.elems.get(index);
        }

        @Override
        public List<T> getOps() {
            return this.elems;
        }

        @Override
        public int[] getSequence() {
            return this.seq;
        }

        public SequencerType getSequencerType() {
            return this.type;
        }

        @Override
        public <U> Sequence<U> transform(Function<T, U> func) {
            return new Sequence(this.type, this.elems.stream().map(func).collect(Collectors.toList()), this.seq);
        }
    }
}

