/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.ratelimits;

import io.nosqlbench.engine.api.activityapi.sysperf.SysPerf;
import io.nosqlbench.engine.api.activityapi.sysperf.SysPerfData;
import java.util.concurrent.locks.LockSupport;

public class LeastWorstDelay {
    public static final SysPerfData perfdata = SysPerf.get().getPerfData(false);
    private static final long sleepThreshold = 1000000L;
    private static final long parkThreshold = 20L;

    public static void delayAsIfFor(long nanos) {
        if (nanos > 0L) {
            if (nanos > 1000000L) {
                nanos -= 1000000L;
                try {
                    Thread.sleep(nanos / 1000000L, (int)(nanos % 1000000L));
                }
                catch (InterruptedException interruptedException) {}
            } else if (nanos > 20L) {
                LockSupport.parkNanos(nanos -= 20L);
            }
        }
    }

    public static void debugDelayAsIfFor(long nanos) {
        if (nanos > 0L) {
            if (nanos > 1000000L) {
                try {
                    System.out.println(String.format("sleeping for %.9fS", (double)nanos / 1.0E9));
                    Thread.sleep(nanos / 1000000L, (int)(nanos % 1000000L));
                }
                catch (InterruptedException interruptedException) {}
            } else if (nanos > 20L) {
                System.out.println(String.format("parking for %.9fS", (double)nanos / 1.0E9));
                LockSupport.parkNanos(nanos);
            }
        }
    }

    public void delayAsIfUntil(long targetNanoTime) {
        long nanos = Math.max(targetNanoTime - System.nanoTime(), 0L);
        if (nanos > 0L) {
            if (nanos > 1000000L) {
                nanos -= 1000000L;
                try {
                    Thread.sleep(nanos / 1000000L, (int)(nanos % 1000000L));
                }
                catch (InterruptedException interruptedException) {}
            } else if (nanos > 20L) {
                LockSupport.parkNanos(nanos -= 20L);
            }
        }
    }
}

