/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.sysperf;

import io.nosqlbench.engine.api.activityapi.sysperf.SysPerfBaseliner;
import io.nosqlbench.engine.api.activityapi.sysperf.SysPerfData;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class SysPerf {
    public static final Logger logger = LoggerFactory.getLogger(SysPerf.class);
    private static final Charset CHARSET = Charset.forName("UTF8");
    private static SysPerfData cachedData;
    private static long currentImplVersion;
    private static SysPerf instance;

    private SysPerf() {
    }

    public static synchronized SysPerf get() {
        throw new RuntimeException("This should not be used in this release.");
    }

    private static File getPerfCacheFile() {
        String sysperfFileName = "/.nosqlbench/sysperf.yaml";
        Optional<File> cacheAt = Optional.ofNullable(System.getenv().get("HOME")).map(s -> s + sysperfFileName).map(File::new);
        return cacheAt.orElseThrow(() -> new RuntimeException("Unable to map file location for " + sysperfFileName));
    }

    public synchronized SysPerfData getPerfData(boolean forceRun) {
        if (forceRun) {
            logger.debug("forced system perf run");
            cachedData = new SysPerfBaseliner().getSysPerfData();
            this.save(true);
        }
        if ((cachedData = this.load()) == null) {
            logger.debug("lazy system perf run");
            cachedData = new SysPerfBaseliner().getSysPerfData();
            this.save(true);
        }
        logger.debug("system peformance data: " + cachedData.toString());
        return cachedData;
    }

    public synchronized void reset() {
        try {
            File cache = SysPerf.getPerfCacheFile();
            if (cache.exists() && !cache.delete()) {
                throw new RuntimeException("Could not delete cache file: " + cache.getCanonicalPath());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized Optional<FileTime> getCacheFileTime() {
        File cache = SysPerf.getPerfCacheFile();
        try {
            return Optional.of(Files.getLastModifiedTime(cache.toPath(), new LinkOption[0]));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public synchronized SysPerfData load() {
        File cache = SysPerf.getPerfCacheFile();
        try {
            SysPerfData perfinfo;
            if (!cache.exists()) {
                return null;
            }
            byte[] bytes = new byte[]{};
            bytes = Files.readAllBytes(cache.toPath());
            String perfdata = new String(bytes, CHARSET);
            Yaml yaml = new Yaml();
            cachedData = perfinfo = (SysPerfData)yaml.load(perfdata);
            logger.info("Loaded previously cached system timing data from " + cache.getCanonicalPath());
            return cachedData;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
            if (cache.exists()) {
                boolean deleted = cache.delete();
                if (deleted) {
                    logger.warn("Deleted unreadable sysperf file " + cache.getPath());
                } else {
                    logger.error("Error deleting unreadable " + cache.getPath());
                }
            }
            return null;
        }
    }

    public synchronized void save(boolean forceSave) {
        File cache = SysPerf.getPerfCacheFile();
        try {
            if (!cache.exists() || forceSave) {
                Files.createDirectories(cache.toPath().getParent(), new FileAttribute[0]);
                Yaml yaml = new Yaml();
                if (cache.exists()) {
                    cache.delete();
                }
                String filedata = yaml.dump(cachedData);
                Files.write(cache.toPath(), filedata.getBytes(CHARSET), StandardOpenOption.CREATE_NEW);
                logger.info("Wrote system timing data to cachefile " + cache.getCanonicalPath());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        currentImplVersion = 1L;
    }
}

