/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.sysperf;

import io.nosqlbench.engine.api.activityapi.sysperf.SysBenchMethodNanoTime;
import io.nosqlbench.engine.api.activityapi.sysperf.SysBenchMethodParkNanos;
import io.nosqlbench.engine.api.activityapi.sysperf.SysBenchMethodThreadSleep;
import io.nosqlbench.engine.api.activityapi.sysperf.SysPerfData;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysPerfBaseliner {
    private static final Logger logger = LoggerFactory.getLogger(SysPerfBaseliner.class);

    public static void main(String[] args) {
        try {
            SysPerfBaseliner sysPerfBaseliner = new SysPerfBaseliner();
            Collection<RunResult> jmhResults = sysPerfBaseliner.runBenchmarks();
            logger.info("SysPerfData (selected details for EB):\n" + new SysPerfData(jmhResults, 1L).toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<RunResult> runBenchmarks() {
        LinkedHashMap<String, Class> namedTests = new LinkedHashMap<String, Class>();
        namedTests.put("nanotime", SysBenchMethodNanoTime.class);
        namedTests.put("parknanos", SysBenchMethodParkNanos.class);
        namedTests.put("sleep", SysBenchMethodThreadSleep.class);
        ArrayList<RunResult> results = new ArrayList<RunResult>();
        namedTests.forEach((n, c) -> {
            try {
                String logfile = Files.createTempFile("jmh_" + n, ".log", new FileAttribute[0]).toString();
                Options options = new OptionsBuilder().forks(1).include(c.getSimpleName()).output(logfile).build();
                logger.info("running microbench for " + n + ", for about 20 seconds; details in " + logfile);
                RunResult runResult = new Runner(options).runSingle();
                results.add(runResult);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return results;
    }

    public SysPerfData getSysPerfData() {
        logger.info("Running system calibration tests for about a minute. This is used to calibrate delay loops, and is done only once.");
        Collection<RunResult> runResult = this.runBenchmarks();
        SysPerfData sysPerfData = new SysPerfData(runResult, 1L);
        logger.info("System timing test complete: " + sysPerfData);
        return sysPerfData;
    }
}

