/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityconfig.rawyaml;

import io.nosqlbench.engine.api.activityconfig.rawyaml.RawStmtsBlock;
import io.nosqlbench.engine.api.activityconfig.rawyaml.RawStmtsDoc;
import io.nosqlbench.engine.api.activityconfig.rawyaml.RawStmtsDocList;
import io.nosqlbench.engine.api.activityconfig.rawyaml.StatementsOwner;
import io.nosqlbench.engine.api.activityconfig.snakecharmer.SnakeYamlCharmer;
import io.nosqlbench.engine.api.activityimpl.ActivityInitializationError;
import io.nosqlbench.nb.api.content.Content;
import io.nosqlbench.nb.api.content.NBIO;
import io.nosqlbench.nb.api.errors.BasicError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;

public class RawYamlStatementLoader {
    List<Function<String, String>> stringTransformers = new ArrayList<Function<String, String>>();

    public RawYamlStatementLoader() {
    }

    public RawYamlStatementLoader(Function<String, String> stringTransformer) {
        this.addTransformer(stringTransformer);
    }

    public RawStmtsDocList load(Logger logger, String fromPath, String ... searchPaths) {
        try {
            Optional<Content<?>> oyaml = NBIO.all().prefix(searchPaths).name(fromPath).extension("yaml").first();
            String data = oyaml.map(Content::asString).orElseThrow(() -> new BasicError("Unable to load " + fromPath));
            data = this.applyTransforms(logger, data);
            return this.parseYaml(logger, data);
        }
        catch (Exception e) {
            throw new RuntimeException("error while reading file " + fromPath, e);
        }
    }

    public void addTransformer(Function<String, String> transformer) {
        this.stringTransformers.add(transformer);
    }

    public RawStmtsDocList load(Logger logger, Path path) {
        try {
            String yamlImg = Files.readString(path);
            return this.parseYaml(logger, yamlImg);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading YAML from search paths: " + e.getMessage(), e);
        }
    }

    protected String applyTransforms(Logger logger, String data) {
        for (Function<String, String> xform : this.stringTransformers) {
            try {
                if (logger != null) {
                    logger.debug("Applying string transformer to yaml data:" + xform);
                }
                data = xform.apply(data);
            }
            catch (Exception e) {
                ActivityInitializationError t = new ActivityInitializationError("Error applying string applyTransforms to input", e);
                if (logger != null) {
                    logger.error(t.getMessage(), t);
                }
                throw t;
            }
        }
        return data;
    }

    protected RawStmtsDocList parseYaml(Logger logger, String data) {
        Yaml yaml = this.getCustomYaml();
        try {
            Iterable<Object> objects = yaml.loadAll(data);
            ArrayList<RawStmtsDoc> stmtListList = new ArrayList<RawStmtsDoc>();
            for (Object object : objects) {
                RawStmtsDoc tgsd = (RawStmtsDoc)object;
                stmtListList.add(tgsd);
            }
            return new RawStmtsDocList(stmtListList);
        }
        catch (Exception e) {
            if (logger != null) {
                logger.error("yaml-construction-error: Error building configuration:" + e.getMessage() + " For more details on this error see the troubleshooting section of the YAML format docs for yaml-construction-error.", e);
            }
            throw e;
        }
    }

    protected Yaml getCustomYaml() {
        SnakeYamlCharmer charmer = new SnakeYamlCharmer(RawStmtsDoc.class);
        charmer.addHandler(StatementsOwner.class, "statements", new StatementsReader());
        charmer.addHandler(StatementsOwner.class, "statement", new StatementsReader());
        TypeDescription tds = new TypeDescription(RawStmtsDoc.class);
        tds.addPropertyParameters("blocks", RawStmtsBlock.class);
        charmer.addTypeDescription(tds);
        return new Yaml(charmer);
    }

    protected RawStmtsDocList loadString(Logger logger, String rawYaml) {
        String data = this.applyTransforms(logger, rawYaml);
        return this.parseYaml(logger, data);
    }

    public RawStmtsDocList loadString(Logger logger, CharSequence rawYaml) {
        String data = this.applyTransforms(logger, rawYaml.toString());
        return this.parseYaml(logger, data);
    }

    private class StatementsReader
    implements SnakeYamlCharmer.FieldHandler {
        private StatementsReader() {
        }

        @Override
        public void handleMapping(Object object, Object nodeTuple) {
            if (object instanceof StatementsOwner) {
                ((StatementsOwner)object).setByObject(nodeTuple);
            }
        }
    }
}

