/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityconfig.yaml;

import io.nosqlbench.engine.api.activityconfig.MultiMapLookup;
import io.nosqlbench.engine.api.activityconfig.ParsedStmt;
import io.nosqlbench.engine.api.activityconfig.rawyaml.RawStmtDef;
import io.nosqlbench.engine.api.activityconfig.yaml.StmtsBlock;
import io.nosqlbench.engine.api.util.Tagged;
import java.util.Map;

public class StmtDef
implements Tagged {
    private final RawStmtDef rawStmtDef;
    private StmtsBlock block;

    public StmtDef(StmtsBlock block, RawStmtDef rawStmtDef) {
        this.block = block;
        this.rawStmtDef = rawStmtDef;
    }

    public String getName() {
        return this.block.getName() + "--" + this.rawStmtDef.getName();
    }

    public String getStmt() {
        return this.rawStmtDef.getStmt();
    }

    public Map<String, String> getBindings() {
        return new MultiMapLookup(this.rawStmtDef.getBindings(), this.block.getBindings());
    }

    public Map<String, String> getParams() {
        return new MultiMapLookup(this.rawStmtDef.getParams(), this.block.getParams());
    }

    @Override
    public Map<String, String> getTags() {
        return new MultiMapLookup(this.rawStmtDef.getTags(), this.block.getTags());
    }

    public String toString() {
        return "stmt(name:" + this.getName() + ", stmt:" + this.getStmt() + ", tags:(" + this.getTags() + "), params:(" + this.getParams() + "), bindings:(" + this.getBindings() + "))";
    }

    public ParsedStmt getParsed() {
        return new ParsedStmt(this);
    }

    public String getDesc() {
        return this.rawStmtDef.getDesc();
    }
}

