/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityimpl;

import java.util.DoubleSummaryStatistics;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.HardwareAbstractionLayer;

public class CpuInfo {
    private static final Logger logger = LoggerFactory.getLogger(CpuInfo.class);
    private static final SystemInfo SYSTEM_INFO = new SystemInfo();

    public static Optional<ProcDetails> getProcDetails() {
        return Optional.of(new ProcDetails(SYSTEM_INFO));
    }

    public static class ProcDetails {
        SystemInfo si;
        HardwareAbstractionLayer hal;
        CentralProcessor processor;

        public ProcDetails(SystemInfo si) {
            this.si = si;
            this.hal = si.getHardware();
            this.processor = this.hal.getProcessor();
        }

        public int getCoreCount() {
            return this.processor.getLogicalProcessorCount();
        }

        public int getCpuCount() {
            return this.processor.getPhysicalProcessorCount();
        }

        public String getModelName() {
            return this.processor.getProcessorIdentifier().toString();
        }

        public String getMhz() {
            return Long.toString(this.processor.getMaxFreq() / 0x100000L);
        }

        public String toString() {
            return "cores=" + this.getCoreCount() + " cpus=" + this.getCpuCount() + " mhz=" + this.getMhz() + " speedavg=" + this.getCurrentSpeed().getAverage() + " model='" + this.getModelName() + "'";
        }

        public double getMaxFreq(int cpu) {
            return this.processor.getMaxFreq();
        }

        public double getCurFreq(int cpu) {
            return this.processor.getCurrentFreq()[cpu];
        }

        public double getCurrentSpeed(int cpu) {
            double curFreq = this.getCurFreq(cpu);
            double maxFreq = this.getMaxFreq(cpu);
            if (Double.isNaN(curFreq) || Double.isNaN(maxFreq)) {
                return Double.NaN;
            }
            return curFreq / maxFreq;
        }

        public DoubleSummaryStatistics getCurrentSpeed() {
            DoubleSummaryStatistics dss = new DoubleSummaryStatistics();
            for (int i = 0; i < this.getCpuCount(); ++i) {
                double currentSpeed = this.getCurrentSpeed(i);
                if (Double.isNaN(currentSpeed)) continue;
                dss.accept(currentSpeed);
            }
            return dss;
        }
    }
}

