/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityimpl.input;

import io.nosqlbench.engine.api.activityapi.core.ActivityDefObserver;
import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.CycleSegment;
import io.nosqlbench.engine.api.activityapi.input.Input;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.engine.api.activityimpl.input.InputInterval;
import io.nosqlbench.engine.api.activityimpl.input.ProgressCapable;
import io.nosqlbench.engine.api.util.Unit;
import java.security.InvalidParameterException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicInput
implements Input,
ActivityDefObserver,
ProgressCapable {
    private static final Logger logger = LoggerFactory.getLogger(AtomicInput.class);
    private final AtomicLong cycleValue = new AtomicLong(0L);
    private final AtomicLong min = new AtomicLong(0L);
    private final AtomicLong max = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong recycleValue = new AtomicLong(0L);
    private final AtomicLong recycleMax = new AtomicLong(0L);
    private ActivityDef activityDef;

    public AtomicInput(ActivityDef activityDef) {
        this.activityDef = activityDef;
        this.onActivityDefUpdate(activityDef);
    }

    @Override
    public CycleSegment getInputSegment(int stride) {
        long next;
        long current;
        do {
            if ((next = (current = this.cycleValue.get()) + (long)stride) <= this.max.get()) continue;
            if (this.recycleValue.get() >= this.recycleMax.get()) {
                logger.trace("Exhausted input for " + this.activityDef.getAlias() + " at " + current + ", recycle count " + this.recycleValue.get());
                return null;
            }
            if (!this.cycleValue.compareAndSet(current, this.min.get() + (long)stride)) continue;
            this.recycleValue.getAndIncrement();
            logger.trace("recycling input for " + this.activityDef.getAlias() + " recycle:" + this.recycleValue.get());
            return new InputInterval.Segment(this.min.get(), this.min.get() + (long)stride);
        } while (!this.cycleValue.compareAndSet(current, next));
        return new InputInterval.Segment(current, next);
    }

    @Override
    public double getProgress() {
        return this.cycleValue.get() - this.min.get();
    }

    @Override
    public double getTotal() {
        return this.max.get() - this.min.get();
    }

    @Override
    public String getProgressDetails() {
        return "min=" + this.min.get() + " cycle=" + this.cycleValue.get() + " max=" + this.max.get() + (String)(this.recycleMax.get() > 0L ? " recycles=" + this.recycleValue.get() + "/" + this.recycleMax.get() : "");
    }

    public String toString() {
        return "AtomicInput{cycleValue=" + this.cycleValue + ", min=" + this.min + ", max=" + this.max + ", activity=" + this.activityDef.getAlias() + "}";
    }

    @Override
    public void onActivityDefUpdate(ActivityDef activityDef) {
        long endCycle;
        if (activityDef.getCycleCount() == 0L && activityDef.getParams().containsKey("cycles")) {
            throw new RuntimeException("You specified cycles, but the range specified means zero cycles: " + activityDef.getParams().get("cycles"));
        }
        long startCycle = activityDef.getStartCycle();
        if (startCycle > (endCycle = activityDef.getEndCycle())) {
            throw new InvalidParameterException("min (" + this.min + ") must be less than or equal to max (" + this.max + ")");
        }
        if (this.max.get() != endCycle) {
            this.max.set(endCycle);
        }
        if (this.min.get() != startCycle) {
            this.min.set(startCycle);
            this.cycleValue.set(this.min.get());
        }
        long recycles = activityDef.getParams().getOptionalString("recycles").flatMap(Unit::longCountFor).orElse(0L);
        this.recycleMax.set(recycles);
    }

    @Override
    public boolean isContiguous() {
        return true;
    }
}

