/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityimpl.marker.longheap;

import io.nosqlbench.engine.api.activityimpl.marker.longheap.LongTreeTracker;

public class TreeTracker1024 {
    private long base = 0L;
    private LongTreeTracker ranges = new LongTreeTracker();
    private LongTreeTracker[] buckets = new LongTreeTracker[32];

    public TreeTracker1024(long base) {
        this.base = base;
        for (int p = 0; p < this.buckets.length; ++p) {
            this.buckets[p] = new LongTreeTracker();
        }
    }

    public TreeTracker1024() {
        this(0L);
    }

    public void setPositionChecked(long position) {
        if (position - this.base < 0L) {
            throw new RuntimeException("position must be greater than or equal to base of " + this.base);
        }
        if (position - this.base > 1023L) {
            throw new RuntimeException("postion must be less than or equal to 1023 + base of " + this.base);
        }
        this.setPosition(position);
    }

    public void setPosition(long position) {
        long ranged = position - this.base;
        int bucket = (int)ranged >> 5;
        long bucketPosition = ranged & 0x1FL;
        if ((this.buckets[bucket].setCompleted(bucketPosition) & 2L) > 0L) {
            this.ranges.setCompleted(bucket);
        }
    }

    public boolean isCompleted(long position) {
        long ranged = position - this.base;
        int bucket = (int)ranged >> 5;
        long innerPos = ranged & 0x1FL;
        return this.buckets[bucket].isCompleted(innerPos);
    }

    public long getLowestCompleted() {
        long lowestCompleted = this.base;
        int lowestBucket = (int)this.ranges.getLowestCompleted();
        lowestCompleted += (long)((lowestBucket + 1) * 32);
        return lowestCompleted += this.buckets[lowestBucket + 1].getLowestCompleted();
    }

    public boolean isCompleted() {
        return this.ranges.isCompleted();
    }
}

