/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.metrics;

import io.nosqlbench.engine.api.metrics.CapabilityHook;
import io.nosqlbench.engine.api.metrics.HdrDeltaHistogramAttachment;
import io.nosqlbench.engine.api.metrics.HdrDeltaHistogramProvider;
import io.nosqlbench.engine.api.metrics.HistoLogChartGenerator;
import io.nosqlbench.engine.api.metrics.MetricsCloseable;
import io.nosqlbench.engine.api.metrics.PeriodicRunnable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.HdrHistogram.HistogramLogWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoIntervalLogger
extends CapabilityHook<HdrDeltaHistogramAttachment>
implements Runnable,
MetricsCloseable {
    private static final Logger logger = LoggerFactory.getLogger(HistoIntervalLogger.class);
    private final String sessionName;
    private long intervalLength;
    private File logfile;
    private PrintStream logStream;
    private HistogramLogWriter writer;
    private Pattern pattern;
    private List<WriterTarget> targets = new CopyOnWriteArrayList<WriterTarget>();
    private PeriodicRunnable<HistoIntervalLogger> executor;
    private long lastRunTime;

    public File getLogfile() {
        return this.logfile;
    }

    public HistoIntervalLogger(String sessionName, File file, Pattern pattern, long intervalLength) {
        this.sessionName = sessionName;
        this.logfile = file;
        this.pattern = pattern;
        this.intervalLength = intervalLength;
        this.startLogging();
    }

    public boolean matches(String metricName) {
        return this.pattern.matcher(metricName).matches();
    }

    public void startLogging() {
        try {
            this.logStream = new PrintStream(this.logfile);
            this.writer = new HistogramLogWriter(this.logStream);
            this.writer.outputComment("logging histograms for session " + this.sessionName);
            this.writer.outputLogFormatVersion();
            long currentTimeMillis = System.currentTimeMillis();
            this.writer.outputStartTime(currentTimeMillis);
            this.writer.setBaseTime(currentTimeMillis);
            this.writer.outputLegend();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Error while starting histogram log writer", e);
        }
        this.executor = new PeriodicRunnable<HistoIntervalLogger>(this.getInterval(), this);
        this.executor.startDaemonThread();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HistoLogger:" + this.pattern + ":" + this.logfile.getPath() + ":" + this.intervalLength);
        return sb.toString();
    }

    public long getInterval() {
        return this.intervalLength;
    }

    @Override
    public synchronized void onCapableAdded(String name, HdrDeltaHistogramAttachment chainedHistogram) {
        if (this.pattern.matcher(name).matches()) {
            this.targets.add(new WriterTarget(name, chainedHistogram.attachHdrDeltaHistogram()));
        }
    }

    @Override
    public synchronized void onCapableRemoved(String name, HdrDeltaHistogramAttachment capable) {
        this.targets.remove(new WriterTarget(name, null));
    }

    @Override
    protected Class<HdrDeltaHistogramAttachment> getCapabilityClass() {
        return HdrDeltaHistogramAttachment.class;
    }

    @Override
    public void run() {
        for (WriterTarget target : this.targets) {
            this.writer.outputIntervalHistogram(target.histoProvider.getNextHdrDeltaHistogram());
        }
        this.lastRunTime = System.currentTimeMillis();
    }

    @Override
    public void closeMetrics() {
        this.executor.close();
        long potentialWriteTime = System.currentTimeMillis();
        if (this.lastRunTime + 1000L < potentialWriteTime) {
            logger.debug("Writing last partial histo log:" + this);
            this.run();
        } else {
            logger.debug("Not writing last partial histo log <1s:" + this);
        }
        this.logStream.close();
    }

    @Override
    public void chart() {
        HistoLogChartGenerator.generateChartFromHistoLog(this);
    }

    private static class WriterTarget
    implements Comparable<WriterTarget> {
        public String name;
        public HdrDeltaHistogramProvider histoProvider;

        public WriterTarget(String name, HdrDeltaHistogramProvider attach) {
            this.name = name;
            this.histoProvider = attach;
        }

        public boolean equals(Object obj) {
            return this.name.equals(((WriterTarget)obj).name);
        }

        @Override
        public int compareTo(WriterTarget obj) {
            return this.name.compareTo(obj.name);
        }
    }
}

