/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.metrics;

import com.mitchtalmadge.asciidata.graph.ASCIIGraph;
import io.nosqlbench.engine.api.metrics.HistoIntervalLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramLogReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoLogChartGenerator {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";
    private static Map<String, ArrayList<Histogram>> histogramsOverTime = new HashMap<String, ArrayList<Histogram>>();
    private static Logger logger = LoggerFactory.getLogger(HistoLogChartGenerator.class);

    public static void generateChartFromHistoLog(HistoIntervalLogger histoIntervalLogger) {
        File logFile = histoIntervalLogger.getLogfile();
        try {
            HistogramLogReader reader = new HistogramLogReader(logFile);
            while (reader.hasNext()) {
                Histogram histogram = (Histogram)reader.nextIntervalHistogram();
                if (histogram == null) continue;
                String tag = histogram.getTag();
                ArrayList<Histogram> histogramList = histogramsOverTime.get(tag);
                if (histogramList == null) {
                    histogramList = new ArrayList();
                }
                histogramList.add(histogram);
                histogramsOverTime.put(tag, histogramList);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        for (Map.Entry<String, ArrayList<Histogram>> p99KV : histogramsOverTime.entrySet()) {
            System.out.println(String.format("Charting p99 Latencies (in microseconds) over time (one second intervals) for %s:", p99KV.getKey()));
            double[] p99s = p99KV.getValue().stream().mapToDouble(x -> x.getValueAtPercentile(99.0) / 1000L).toArray();
            System.out.println("checking histogram length");
            System.out.flush();
            if (p99s.length < 2) {
                System.out.println("Not enough data to chart");
                System.out.flush();
                continue;
            }
            System.out.println(ANSI_RED + ASCIIGraph.fromSeries(p99s).withNumRows(8).plot() + ANSI_RESET);
            System.out.println(String.format("Charting throughput (number of transactions per second) for %s:", p99KV.getKey()));
            double[] rates = p99KV.getValue().stream().mapToDouble(x -> x.getTotalCount()).toArray();
            System.out.println(ANSI_GREEN + ASCIIGraph.fromSeries(rates).withNumRows(8).plot() + ANSI_GREEN);
        }
        System.out.println(ANSI_RESET);
    }
}

