/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.Timer;

public class MetricsRegistryMount
implements MetricRegistryListener {
    private final MetricRegistry owningRegistry;
    private final MetricRegistry mountedRegistry;
    private final String mountedPrefix;

    public MetricsRegistryMount(MetricRegistry owningRegistry, MetricRegistry mountedRegistry, String mountedPrefix) {
        this.owningRegistry = owningRegistry;
        this.mountedRegistry = mountedRegistry;
        this.mountedPrefix = mountedPrefix;
        mountedRegistry.addListener(this);
    }

    @Override
    public void onGaugeAdded(String name, Gauge<?> gauge) {
        this.owningRegistry.register(this.mountedPrefix + name, gauge);
    }

    @Override
    public void onGaugeRemoved(String name) {
        this.owningRegistry.remove(this.mountedPrefix + name);
    }

    @Override
    public void onCounterAdded(String name, Counter counter) {
        this.owningRegistry.register(this.mountedPrefix + name, counter);
    }

    @Override
    public void onCounterRemoved(String name) {
        this.owningRegistry.remove(this.mountedPrefix + name);
    }

    @Override
    public void onHistogramAdded(String name, Histogram histogram) {
        this.owningRegistry.register(this.mountedPrefix + name, histogram);
    }

    @Override
    public void onHistogramRemoved(String name) {
        this.owningRegistry.remove(this.mountedPrefix + name);
    }

    @Override
    public void onMeterAdded(String name, Meter meter) {
        this.owningRegistry.register(this.mountedPrefix + name, meter);
    }

    @Override
    public void onMeterRemoved(String name) {
        this.owningRegistry.remove(this.mountedPrefix + name);
    }

    @Override
    public void onTimerAdded(String name, Timer timer) {
        this.owningRegistry.register(this.mountedPrefix + name, timer);
    }

    @Override
    public void onTimerRemoved(String name) {
        this.owningRegistry.remove(this.mountedPrefix + name);
    }
}

