/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.metrics;

import com.codahale.metrics.Histogram;
import io.nosqlbench.engine.api.metrics.ConvenientSnapshot;
import io.nosqlbench.engine.api.metrics.DeltaHdrHistogramReservoir;
import io.nosqlbench.engine.api.metrics.DeltaSnapshotReader;
import io.nosqlbench.engine.api.metrics.DeltaSnapshotter;
import io.nosqlbench.engine.api.metrics.HdrDeltaHistogramAttachment;
import io.nosqlbench.engine.api.metrics.HistogramAttachment;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class NicerHistogram
extends Histogram
implements DeltaSnapshotter,
HdrDeltaHistogramAttachment,
HistogramAttachment {
    private final DeltaHdrHistogramReservoir hdrDeltaReservoir;
    private long cacheExpiryMillis = 0L;
    private long cacheTimeMillis = 0L;
    private String metricName;
    private List<Histogram> mirrors;

    public NicerHistogram(String metricName, DeltaHdrHistogramReservoir hdrHistogramReservoir) {
        super(hdrHistogramReservoir);
        this.metricName = metricName;
        this.hdrDeltaReservoir = hdrHistogramReservoir;
    }

    @Override
    public DeltaSnapshotReader getDeltaReader() {
        return new DeltaSnapshotReader(this);
    }

    @Override
    public ConvenientSnapshot getSnapshot() {
        if (System.currentTimeMillis() < this.cacheExpiryMillis) {
            return new ConvenientSnapshot(this.hdrDeltaReservoir.getLastSnapshot());
        }
        return new ConvenientSnapshot(this.hdrDeltaReservoir.getSnapshot());
    }

    @Override
    public ConvenientSnapshot getDeltaSnapshot(long cacheTimeMillis) {
        this.cacheTimeMillis = cacheTimeMillis;
        this.cacheExpiryMillis = System.currentTimeMillis() + this.cacheTimeMillis;
        ConvenientSnapshot convenientSnapshot = new ConvenientSnapshot(this.hdrDeltaReservoir.getSnapshot());
        return convenientSnapshot;
    }

    @Override
    public synchronized NicerHistogram attachHdrDeltaHistogram() {
        if (this.mirrors == null) {
            this.mirrors = new CopyOnWriteArrayList<Histogram>();
        }
        DeltaHdrHistogramReservoir mirrorReservoir = this.hdrDeltaReservoir.copySettings();
        NicerHistogram mirror = new NicerHistogram("mirror-" + this.metricName, mirrorReservoir);
        this.mirrors.add(mirror);
        return mirror;
    }

    @Override
    public Histogram attachHistogram(Histogram histogram) {
        if (this.mirrors == null) {
            this.mirrors = new CopyOnWriteArrayList<Histogram>();
        }
        this.mirrors.add(histogram);
        return histogram;
    }

    @Override
    public void update(long value) {
        super.update(value);
        if (this.mirrors != null) {
            for (Histogram mirror : this.mirrors) {
                mirror.update(value);
            }
        }
    }

    @Override
    public org.HdrHistogram.Histogram getNextHdrDeltaHistogram() {
        return this.hdrDeltaReservoir.getNextHdrHistogram();
    }
}

