/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.scenarios;

import io.nosqlbench.engine.api.activityconfig.StatementsLoader;
import io.nosqlbench.engine.api.activityconfig.yaml.Scenarios;
import io.nosqlbench.engine.api.activityconfig.yaml.StmtsDocList;
import io.nosqlbench.engine.api.scenarios.WorkloadDesc;
import io.nosqlbench.engine.api.templating.StrInterpolator;
import io.nosqlbench.nb.api.config.Synonyms;
import io.nosqlbench.nb.api.content.Content;
import io.nosqlbench.nb.api.content.NBIO;
import io.nosqlbench.nb.api.errors.BasicError;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NBCLIScenarioParser {
    public static final String SILENT_LOCKED = "==";
    public static final String VERBOSE_LOCKED = "===";
    public static final String UNLOCKED = "=";
    private static final Logger logger = LoggerFactory.getLogger(NBCLIScenarioParser.class);
    private static final String SEARCH_IN = "activities";
    public static final String WORKLOAD_SCENARIO_STEP = "WORKLOAD_SCENARIO_STEP";
    private static final Pattern WordAndMaybeAssignment = Pattern.compile("(?<name>\\w+)((?<oper>=+)(?<val>.+))?");
    private static Pattern templatePattern = Pattern.compile("TEMPLATE\\((.+?)\\)");
    private static Pattern innerTemplatePattern = Pattern.compile("TEMPLATE\\((.+?)$");
    private static Pattern templatePattern2 = Pattern.compile("<<(.+?)>>");

    public static boolean isFoundWorkload(String workload, String ... includes) {
        Optional<Content<?>> found = NBIO.all().prefix(SEARCH_IN).prefix(includes).name(workload).extension("yaml").first();
        return found.isPresent();
    }

    public static void parseScenarioCommand(LinkedList<String> arglist, Set<String> RESERVED_WORDS, String ... includes) {
        String workloadName = arglist.removeFirst();
        Optional<Content<?>> found = NBIO.all().prefix(SEARCH_IN).prefix(includes).name(workloadName).extension("yaml").first();
        Content<?> workloadContent = found.orElseThrow();
        ArrayList<String> scenarioNames = new ArrayList<String>();
        while (!(arglist.size() <= 0 || arglist.peekFirst().contains(UNLOCKED) || arglist.peekFirst().startsWith("-") || RESERVED_WORDS.contains(arglist.peekFirst()))) {
            scenarioNames.add(arglist.removeFirst());
        }
        if (scenarioNames.size() == 0) {
            scenarioNames.add("default");
        }
        LinkedHashMap<String, String> userParams = new LinkedHashMap<String, String>();
        while (arglist.size() > 0 && arglist.peekFirst().contains(UNLOCKED) && !arglist.peekFirst().startsWith("-")) {
            String[] arg = arglist.removeFirst().split(UNLOCKED);
            arg[0] = Synonyms.canonicalize(arg[0], logger);
            if (userParams.containsKey(arg[0])) {
                throw new BasicError("duplicate occurrence of option on command line: " + arg[0]);
            }
            userParams.put(arg[0], arg[1]);
        }
        StrInterpolator userParamsInterp = new StrInterpolator(userParams);
        LinkedList buildCmdBuffer = new LinkedList();
        for (String scenarioName : scenarioNames) {
            Content<?> yamlWithNamedScenarios = NBIO.all().prefix(SEARCH_IN).prefix(includes).name(workloadName).extension("yaml").one();
            StmtsDocList stmts = StatementsLoader.load(logger, yamlWithNamedScenarios);
            Scenarios scenarios = stmts.getDocScenarios();
            Map<String, String> namedSteps = scenarios.getNamedScenario(scenarioName);
            if (namedSteps == null) {
                throw new BasicError("Unable to find named scenario '" + scenarioName + "' in workload '" + workloadName + "', but you can pick from " + String.join((CharSequence)",", scenarios.getScenarioNames()));
            }
            for (Map.Entry<String, String> cmdEntry : namedSteps.entrySet()) {
                String stepName = cmdEntry.getKey();
                String cmd = cmdEntry.getValue();
                cmd = userParamsInterp.apply(cmd);
                LinkedHashMap<String, CmdArg> parsedStep = NBCLIScenarioParser.parseStep(cmd);
                LinkedHashMap<String, String> usersCopy = new LinkedHashMap<String, String>(userParams);
                LinkedHashMap<String, Object> buildingCmd = new LinkedHashMap<String, Object>();
                for (CmdArg cmdarg : parsedStep.values()) {
                    if (usersCopy.containsKey(cmdarg.getName())) {
                        cmdarg = cmdarg.override((String)usersCopy.remove(cmdarg.getName()));
                    }
                    buildingCmd.put(cmdarg.getName(), cmdarg.toString());
                }
                usersCopy.forEach((k, v) -> buildingCmd.put((String)k, k + UNLOCKED + v));
                List<String> undefKeys = buildingCmd.entrySet().stream().filter(e -> ((String)e.getValue()).toLowerCase().endsWith("=undef")).map(Map.Entry::getKey).collect(Collectors.toList());
                undefKeys.forEach(buildingCmd::remove);
                if (!buildingCmd.containsKey("workload")) {
                    String relativeWorkloadPathFromRoot = yamlWithNamedScenarios.asPath().toString();
                    relativeWorkloadPathFromRoot = relativeWorkloadPathFromRoot.startsWith("/") ? relativeWorkloadPathFromRoot.substring(1) : relativeWorkloadPathFromRoot;
                    buildingCmd.put("workload", "workload=" + relativeWorkloadPathFromRoot);
                }
                if (!buildingCmd.containsKey("alias")) {
                    buildingCmd.put("alias", "alias=WORKLOAD_SCENARIO_STEP");
                }
                Object alias = (String)buildingCmd.get("alias");
                for (String token : new String[]{"WORKLOAD", "SCENARIO", "STEP"}) {
                    if (((String)alias).contains(token)) continue;
                    logger.warn("Your alias template '" + (String)alias + "' does not contain " + token + ", which will cause your metrics to be combined under the same name. It is strongly advised that you include them in a template like WORKLOAD_SCENARIO_STEP.");
                }
                alias = ((String)alias).replaceAll("WORKLOAD", workloadContent.asPath().getFileName().toString().replaceAll(".yaml", ""));
                alias = ((String)alias).replaceAll("SCENARIO", scenarioName);
                alias = ((String)(alias = ((String)alias).replaceAll("STEP", stepName))).startsWith("alias=") ? alias : "alias=" + (String)alias;
                buildingCmd.put("alias", alias);
                logger.debug("Named scenario built command: " + String.join((CharSequence)" ", buildingCmd.values()));
                buildCmdBuffer.addAll(buildingCmd.values());
            }
        }
        buildCmdBuffer.descendingIterator().forEachRemaining(arglist::addFirst);
    }

    private static LinkedHashMap<String, CmdArg> parseStep(String cmd) {
        String[] namedStepPieces;
        LinkedHashMap<String, CmdArg> parsedStep = new LinkedHashMap<String, CmdArg>();
        for (String commandFragment : namedStepPieces = cmd.split(" ")) {
            Matcher matcher = WordAndMaybeAssignment.matcher(commandFragment);
            if (!matcher.matches()) {
                throw new BasicError("Unable to recognize scenario cmd spec in '" + commandFragment + "'");
            }
            String commandName = matcher.group("name");
            commandName = Synonyms.canonicalize(commandName, logger);
            String assignmentOp = matcher.group("oper");
            String assignedValue = matcher.group("val");
            parsedStep.put(commandName, new CmdArg(commandName, assignmentOp, assignedValue));
        }
        return parsedStep;
    }

    public static List<WorkloadDesc> getWorkloadsWithScenarioScripts(String ... includes) {
        List<Content<?>> activities = NBIO.all().prefix(SEARCH_IN).prefix(includes).extension("yaml").list();
        List yamlPathList = activities.stream().map(Content::asPath).collect(Collectors.toList());
        ArrayList<WorkloadDesc> workloadDescriptions = new ArrayList<WorkloadDesc>();
        for (Path yamlPath : yamlPathList) {
            Scenarios scenarios;
            List<String> scenarioNames;
            String referenced = yamlPath.toString();
            referenced = referenced.startsWith("/") ? referenced.substring(1) : referenced;
            Content<?> content = NBIO.all().prefix(SEARCH_IN).name(referenced).extension("yaml").one();
            StmtsDocList stmts = StatementsLoader.load(logger, content);
            Map<String, String> templates = new LinkedHashMap<String, String>();
            try {
                List<String> lines = Files.readAllLines(yamlPath);
                for (String line : lines) {
                    templates = NBCLIScenarioParser.matchTemplates(line, templates);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if ((scenarioNames = (scenarios = stmts.getDocScenarios()).getScenarioNames()) == null || scenarioNames.size() <= 0) continue;
            String path = yamlPath.toString();
            path = path.startsWith(FileSystems.getDefault().getSeparator()) ? path.substring(1) : path;
            LinkedHashMap<String, String> sortedTemplates = new LinkedHashMap<String, String>();
            ArrayList<String> keyNames = new ArrayList<String>(templates.keySet());
            Collections.sort(keyNames);
            for (String keyName : keyNames) {
                sortedTemplates.put(keyName, templates.get(keyName));
            }
            String description = stmts.getDescription();
            workloadDescriptions.add(new WorkloadDesc(path, scenarioNames, sortedTemplates, description));
        }
        return workloadDescriptions;
    }

    public static Map<String, String> matchTemplates(String line, Map<String, String> templates) {
        String match;
        Matcher matcher = templatePattern.matcher(line);
        while (matcher.find()) {
            match = matcher.group(1);
            Matcher innerMatcher = innerTemplatePattern.matcher(match);
            String[] matchArray = match.split(",");
            if (innerMatcher.find()) {
                String[] innerMatch = innerMatcher.group(1).split(",");
                templates.put(matchArray[0], innerMatch[1]);
                continue;
            }
            templates.put(matchArray[0], matchArray[1]);
        }
        matcher = templatePattern2.matcher(line);
        while (matcher.find()) {
            match = matcher.group(1);
            String[] matchArray = match.split(":");
            if (matchArray.length == 1) {
                templates.put(matchArray[0], "-none-");
                continue;
            }
            templates.put(matchArray[0], matchArray[1]);
        }
        return templates;
    }

    private static final class CmdArg {
        private final String name;
        private final String operator;
        private final String value;
        private String scenarioName;

        public CmdArg(String name, String operator, String value) {
            this.name = name;
            this.operator = operator;
            this.value = value;
        }

        public boolean isReassignable() {
            return NBCLIScenarioParser.UNLOCKED.equals(this.operator);
        }

        public boolean isFinalSilent() {
            return NBCLIScenarioParser.SILENT_LOCKED.equals(this.operator);
        }

        public boolean isFinalVerbose() {
            return NBCLIScenarioParser.VERBOSE_LOCKED.equals(this.operator);
        }

        public CmdArg override(String value) {
            if (this.isReassignable()) {
                return new CmdArg(this.name, this.operator, value);
            }
            if (this.isFinalSilent()) {
                return this;
            }
            if (this.isFinalVerbose()) {
                throw new BasicError("Unable to reassign value for locked param '" + this.name + this.operator + value + "'");
            }
            throw new RuntimeException("impossible!");
        }

        public String toString() {
            return this.name + (this.operator != null ? NBCLIScenarioParser.UNLOCKED : "") + (this.value != null ? this.value : "");
        }

        public String getName() {
            return this.name;
        }
    }
}

