/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.scenarios;

import java.util.List;
import java.util.Map;

public class WorkloadDesc {
    private final String yamlPath;
    private final List<String> scenarioNames;
    private final Map<String, String> templates;
    private final String description;

    public WorkloadDesc(String yamlPath, List<String> scenarioNames, Map<String, String> templates, String description) {
        this.yamlPath = yamlPath;
        this.scenarioNames = scenarioNames;
        this.templates = templates;
        this.description = description;
    }

    public String getYamlPath() {
        return this.yamlPath;
    }

    public String getWorkloadName() {
        return this.getYamlPath().replaceAll("\\.yaml", "");
    }

    public List<String> getScenarioNames() {
        return this.scenarioNames;
    }

    public Map<String, String> getTemplates() {
        return this.templates;
    }

    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeScenarios) {
        StringBuilder sb = new StringBuilder();
        if (includeScenarios) {
            sb.append("# workload in ");
        }
        sb.append(this.getYamlPath()).append("\n");
        if (!this.description.isEmpty()) {
            sb.append("# description:\n").append(this.description);
            if (!this.description.endsWith("\n")) {
                sb.append("\n");
            }
        }
        if (includeScenarios) {
            sb.append("    # scenarios:\n");
            for (String string : this.getScenarioNames()) {
                sb.append("    nb ").append(this.getWorkloadName()).append(" ").append(string).append("\n");
            }
            if (this.templates.size() > 0) {
                sb.append("        # defaults\n");
            }
            for (Map.Entry entry : this.templates.entrySet()) {
                sb.append("        ").append((String)entry.getKey()).append(" = ").append((String)entry.getValue()).append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

