/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.templating;

import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.text.StrLookup;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;

public class StrInterpolator
implements Function<String, String> {
    private MultiMap multimap = new MultiMap();
    private StringSubstitutor substitutor = new StringSubstitutor((StringLookup)this.multimap, "<<", ">>", '\\').setEnableSubstitutionInVariables(true).setEnableUndefinedVariableException(true).setDisableSubstitutionInValues(true);
    private StringSubstitutor substitutor2 = new StringSubstitutor((StringLookup)this.multimap, "TEMPLATE(", ")", '\\').setEnableSubstitutionInVariables(true).setEnableUndefinedVariableException(true).setDisableSubstitutionInValues(true);

    public StrInterpolator(ActivityDef ... activityDefs) {
        Arrays.stream(activityDefs).map(ad -> ad.getParams().getStringStringMap()).forEach(this.multimap::add);
    }

    public StrInterpolator(Map<String, String> basicMap) {
        this.multimap.add(basicMap);
    }

    protected StrInterpolator(List<Map<String, String>> maps) {
        maps.forEach(this.multimap::add);
    }

    @Override
    public String apply(String raw) {
        String after = this.substitutor.replace(this.substitutor2.replace(raw));
        while (!after.equals(raw)) {
            raw = after;
            after = this.substitutor.replace(this.substitutor2.replace(raw));
        }
        return after;
    }

    public LinkedHashMap<String, String> getTemplateDetails(String input) {
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>();
        return details;
    }

    public static class MultiMap
    extends StrLookup<String> {
        private List<Map<String, String>> maps = new ArrayList<Map<String, String>>();
        private String warnPrefix = "UNSET";

        public void add(Map<String, String> addedMap) {
            this.maps.add(addedMap);
        }

        @Override
        public String lookup(String key) {
            String defval = null;
            String[] parts = key.split("[:,]", 2);
            if (parts.length == 2) {
                key = parts[0];
                defval = parts[1];
            }
            for (Map<String, String> map : this.maps) {
                String val = map.get(key);
                if (val == null) continue;
                return val;
            }
            return defval != null ? defval : this.warnPrefix + ":" + key;
        }
    }
}

