/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.util;

import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import java.io.File;
import java.security.KeyStore;
import java.util.Optional;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLKsFactory {
    private static final Logger logger = LoggerFactory.getLogger(SSLKsFactory.class);
    private static final SSLKsFactory instance = new SSLKsFactory();

    private SSLKsFactory() {
    }

    public static SSLKsFactory get() {
        return instance;
    }

    public ServerSocketFactory createSSLServerSocketFactory(ActivityDef def) {
        SslContext context = this.getContext(def);
        if (context == null) {
            throw new IllegalArgumentException("SSL is not enabled.");
        }
        return ((JdkSslContext)context).context().getServerSocketFactory();
    }

    public SocketFactory createSocketFactory(ActivityDef def) {
        SslContext context = this.getContext(def);
        if (context == null) {
            throw new IllegalArgumentException("SSL is not enabled.");
        }
        return ((JdkSslContext)context).context().getSocketFactory();
    }

    public SslContext getContext(ActivityDef def) {
        Optional<String> sslParam = def.getParams().getOptionalString("ssl");
        if (sslParam.isPresent()) {
            String tlsVersion = def.getParams().getOptionalString("tlsversion").orElse("TLSv1.2");
            if (sslParam.get().equals("jdk") || sslParam.get().equals("true")) {
                TrustManagerFactory tmf;
                KeyManagerFactory kmf;
                if (sslParam.get().equals("true")) {
                    logger.warn("Please update your 'ssl=true' parameter to 'ssl=jdk'");
                }
                Optional<String> keystorePath = def.getParams().getOptionalString("keystore");
                Optional<String> keystorePass = def.getParams().getOptionalString("kspass");
                char[] keyPassword = def.getParams().getOptionalString("keyPassword").map(String::toCharArray).orElse(null);
                Optional<String> truststorePath = def.getParams().getOptionalString("truststore");
                Optional<String> truststorePass = def.getParams().getOptionalString("tspass");
                KeyStore ks = keystorePath.map(ksPath -> {
                    try {
                        return KeyStore.getInstance(new File((String)ksPath), keystorePass.map(String::toCharArray).orElse(null));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to load the keystore. Please check.", e);
                    }
                }).orElse(null);
                try {
                    kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    kmf.init(ks, keyPassword);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to init KeyManagerFactory. Please check.", e);
                }
                KeyStore ts = truststorePath.map(tsPath -> {
                    try {
                        return KeyStore.getInstance(new File((String)tsPath), truststorePass.map(String::toCharArray).orElse(null));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to load the truststore. Please check.", e);
                    }
                }).orElse(null);
                try {
                    tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(ts != null ? ts : ks);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to init TrustManagerFactory. Please check.", e);
                }
                try {
                    return SslContextBuilder.forClient().protocols(tlsVersion).trustManager(tmf).keyManager(kmf).build();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (sslParam.get().equals("openssl")) {
                File caCertFileLocation = def.getParams().getOptionalString("caCertFilePath").map(File::new).orElse(null);
                File certFileLocation = def.getParams().getOptionalString("certFilePath").map(File::new).orElse(null);
                File keyFileLocation = def.getParams().getOptionalString("keyFilePath").map(File::new).orElse(null);
                try {
                    return SslContextBuilder.forClient().protocols(tlsVersion).trustManager(caCertFileLocation).keyManager(certFileLocation, keyFileLocation).build();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException("The 'ssl' parameter must have one of jdk, or openssl");
        }
        return null;
    }
}

