/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.config;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class Synonyms {
    public static final Map<String, Set<String>> PARAM_SYNONYMS = new HashMap<String, Set<String>>(){
        {
            this.put("hosts", Set.of("host"));
            this.put("workload", Set.of("yaml"));
            this.put("driver", Set.of("type"));
            this.put("cyclerate", Set.of("targetrate"));
        }
    };

    public static String canonicalize(String input, Map<String, Set<String>> synonyms, BiConsumer<String, String> warnings) {
        String replaced = input;
        for (Map.Entry<String, Set<String>> syns : synonyms.entrySet()) {
            String preferred = syns.getKey();
            Iterator<String> iterator = syns.getValue().iterator();
            while (iterator.hasNext()) {
                String prior = replaced;
                String deprecated = iterator.next();
                Pattern p = Pattern.compile("\\b" + deprecated + "\\b");
                if (prior.equals(replaced = replaced.replaceAll(p.pattern(), preferred)) || warnings == null) continue;
                warnings.accept(deprecated, preferred);
            }
        }
        return replaced;
    }

    public static String canonicalize(String arg, Logger logger) {
        return Synonyms.canonicalize(arg, PARAM_SYNONYMS, (d, p) -> logger.warn("Identified deprecated use of '" + d + ", please use '" + p + "' as the preferred form to remove this warning."));
    }
}

