/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.content;

import io.nosqlbench.nb.api.content.Content;
import io.nosqlbench.nb.api.content.NBIOWalker;
import io.nosqlbench.nb.api.content.NBPathsAPI;
import io.nosqlbench.nb.api.content.PathContent;
import io.nosqlbench.nb.api.content.URIResolver;
import io.nosqlbench.nb.api.content.URIResolvers;
import io.nosqlbench.nb.api.errors.BasicError;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;

public class NBIO
implements NBPathsAPI.Facets {
    private static String[] globalIncludes = new String[0];
    private URIResolver resolver;
    private List<String> names = new ArrayList<String>();
    private List<String> extensions = new ArrayList<String>();
    private List<String> prefixes = Arrays.asList(globalIncludes);

    public static synchronized void addGlobalIncludes(String[] globalIncludes) {
        NBIO.globalIncludes = globalIncludes;
    }

    private NBIO() {
    }

    private NBIO(URIResolver resolver, List<String> prefixes, List<String> names, List<String> extensions) {
        this.resolver = resolver;
        this.prefixes = prefixes;
        this.names = names;
        this.extensions = extensions;
    }

    public static List<String> readLines(String filename) {
        Content<?> data = NBIO.all().prefix("data").name(filename).first().orElseThrow();
        String[] split = data.getCharBuffer().toString().split("\n");
        return Arrays.asList(split);
    }

    public static CSVParser readFileCSV(String filename, String ... searchPaths) {
        return NBIO.readFileDelimCSV(filename, ',', searchPaths);
    }

    public static CSVParser readFileDelimCSV(String filename, char delim, String ... searchPaths) {
        Reader reader = NBIO.readReader(filename, searchPaths);
        CSVFormat format = CSVFormat.newFormat(delim).withFirstRecordAsHeader();
        try {
            CSVParser parser = new CSVParser(reader, format);
            return parser;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static InputStream readInputStream(String filename, String ... searchPaths) {
        return NBIO.all().prefix(searchPaths).name(filename).one().getInputStream();
    }

    private static Reader readReader(String filename, String ... searchPaths) {
        return NBIO.all().prefix(searchPaths).name(filename).one().getReader();
    }

    public static CharBuffer readCharBuffer(String fileName, String ... searchPaths) {
        return NBIO.all().prefix(searchPaths).name(fileName).one().getCharBuffer();
    }

    public static Path getFirstLocalPath(String ... potentials) {
        Optional<Content<?>> first = NBIO.local().name(potentials).first();
        return first.orElseThrow().asPath();
    }

    public static Optional<Path> findFirstLocalPath(String ... potentials) {
        Optional<Content<?>> first = NBIO.local().name(potentials).first();
        Optional<Path> path = first.map(Content::asPath);
        return path;
    }

    public static InputStream readInputStream(String fromPath, String yaml, String[] searchPaths) {
        return null;
    }

    @Override
    public NBPathsAPI.GetPrefix localContent() {
        this.resolver = URIResolvers.inFS().inCP();
        return this;
    }

    @Override
    public NBPathsAPI.GetPrefix remoteContent() {
        this.resolver = URIResolvers.inURLs();
        return this;
    }

    @Override
    public NBPathsAPI.GetPrefix internalContent() {
        this.resolver = URIResolvers.inClasspath();
        return this;
    }

    @Override
    public NBPathsAPI.GetPrefix fileContent() {
        this.resolver = URIResolvers.inFS();
        return this;
    }

    @Override
    public NBPathsAPI.GetPrefix allContent() {
        this.resolver = URIResolvers.inFS().inCP().inURLs();
        return this;
    }

    @Override
    public NBPathsAPI.GetPrefix prefix(String ... searchPaths) {
        ArrayList<String> addingPaths = new ArrayList<String>(this.prefixes);
        addingPaths.addAll(Arrays.asList(searchPaths));
        return new NBIO(this.resolver, addingPaths, this.names, this.extensions);
    }

    @Override
    public NBPathsAPI.GetExtension name(String ... searchNames) {
        ArrayList<String> addingNames = new ArrayList<String>(this.names);
        addingNames.addAll(Arrays.asList(searchNames));
        return new NBIO(this.resolver, this.prefixes, addingNames, this.extensions);
    }

    @Override
    public NBPathsAPI.DoSearch extension(String ... extensions) {
        ArrayList<String> addingExtensions = new ArrayList<String>(this.extensions);
        for (String addingExtension : extensions) {
            addingExtensions.add(NBIO.dotExtension(addingExtension));
        }
        return new NBIO(this.resolver, this.prefixes, this.names, addingExtensions);
    }

    public static NBPathsAPI.GetPrefix all() {
        return new NBIO().allContent();
    }

    public static NBPathsAPI.GetPrefix classpath() {
        return new NBIO().internalContent();
    }

    public static NBPathsAPI.GetPrefix fs() {
        return new NBIO().fileContent();
    }

    public static NBPathsAPI.GetPrefix local() {
        return new NBIO().localContent();
    }

    public static NBPathsAPI.GetPrefix remote() {
        return new NBIO().remoteContent();
    }

    @Override
    public Optional<Content<?>> first() {
        List<Content<?>> list = this.list();
        if (list.size() > 0) {
            return Optional.of(list.get(0));
        }
        return Optional.empty();
    }

    public Optional<Content<?>> maybeOne() {
        List<Content<?>> list = this.list();
        if (list.size() > 1) {
            throw new BasicError("Found more than one source for " + this.toString() + ", but expected to find one at most.");
        }
        throw new RuntimeException("Invalid code, go fix it, this should never happen.");
    }

    @Override
    public Content<?> one() {
        List<Content<?>> list = this.list();
        if (list.size() == 0) {
            throw new BasicError("Unable to find even a single source for '" + this.toString() + "'");
        }
        if (list.size() > 1) {
            String found = list.stream().map(c -> c.getURI().toString()).collect(Collectors.joining(","));
            throw new BasicError("Found too many sources for '" + this.toString() + "', ambiguous name. Pick from " + found);
        }
        return list.get(0);
    }

    @Override
    public List<List<Content<?>>> resolveEach() {
        ArrayList resolved = new ArrayList();
        for (String name : this.names) {
            LinkedHashSet<String> slotSearchPaths = this.expandSearches(this.prefixes, List.of(name), this.extensions, false);
            Object content = null;
            for (String slotSearchPath : slotSearchPaths) {
                List<Content<?>> contents = this.resolver.resolve(slotSearchPath);
                resolved.add(contents);
            }
        }
        return resolved;
    }

    public LinkedHashSet<String> expandSearches() {
        return this.expandSearches(this.prefixes, this.names, this.extensions, false);
    }

    public LinkedHashSet<String> expandSearches(List<String> thePrefixes, List<String> names, List<String> suffixes, boolean eachPrefix) {
        ArrayList<String> prefixesToSearch = new ArrayList<String>(thePrefixes);
        ArrayList<String> namesToSearch = new ArrayList<String>(names);
        ArrayList<String> suffixesToSearch = new ArrayList<String>(suffixes);
        if (prefixesToSearch.size() == 0) {
            prefixesToSearch.add("");
        }
        if (namesToSearch.size() == 0) {
            namesToSearch.add(".*");
        }
        if (suffixesToSearch.size() == 0) {
            suffixesToSearch.add("");
        }
        LinkedHashSet<String> searches = new LinkedHashSet<String>();
        for (String name : namesToSearch) {
            Iterator iterator = suffixesToSearch.iterator();
            while (iterator.hasNext()) {
                String search = name;
                String suffix = (String)iterator.next();
                String string = search = search.endsWith(suffix) ? search : search + suffix;
                if (eachPrefix) {
                    for (String prefix : prefixesToSearch) {
                        String withPrefix = (String)(prefix.isEmpty() ? prefix : prefix + FileSystems.getDefault().getSeparator()) + search;
                        searches.add(withPrefix);
                    }
                    continue;
                }
                searches.add(search);
            }
        }
        return searches;
    }

    @Override
    public List<Content<?>> list() {
        List<Comparable<Content<?>>> founds;
        LinkedHashSet<String> searches = this.expandSearches();
        LinkedHashSet foundFiles = new LinkedHashSet();
        for (String search : searches) {
            founds = this.resolver.resolve(search);
            foundFiles.addAll(founds);
        }
        for (String searchPath : this.prefixes) {
            founds = this.resolver.resolveDirectory(searchPath);
            NBIOWalker.CollectVisitor capture = new NBIOWalker.CollectVisitor(true, false);
            for (Path path : founds) {
                for (String searchPattern : searches) {
                    NBIOWalker.RegexFilter filter = new NBIOWalker.RegexFilter(searchPattern, true);
                    NBIOWalker.walkFullPath(path, capture, filter);
                }
            }
            capture.get().stream().map(PathContent::new).forEach(foundFiles::add);
        }
        return new ArrayList(foundFiles);
    }

    private static String tailmatch(String name) {
        if (!((String)name).startsWith("^") && !((String)name).startsWith(".")) {
            name = ".*" + (String)name;
        }
        return name;
    }

    private static String dotExtension(String extension) {
        return extension.startsWith(".") ? extension : "." + extension;
    }

    public String toString() {
        return "NBIO{resolver=" + this.resolver + ", prefixes=" + this.prefixes + ", names=" + this.names + ", extensions=" + this.extensions + "}";
    }
}

