/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.content;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NBIOWalker {
    private static final Logger logger = LogManager.getLogger(NBIOWalker.class);
    public static DirectoryStream.Filter<Path> WALK_ALL = entry -> true;

    public static void walk(Path p, PathVisitor v) {
        NBIOWalker.walkShortPath(p, v, WALK_ALL);
    }

    public static List<Path> findAll(Path p) {
        CollectVisitor fileCollector = new CollectVisitor(true, false);
        NBIOWalker.walk(p, fileCollector);
        return fileCollector.get();
    }

    public static void walkShortPath(Path p, PathVisitor v, DirectoryStream.Filter<Path> filter) {
        NBIOWalker.walk(null, p, v, filter, false);
    }

    public static void walkFullPath(Path p, PathVisitor v, DirectoryStream.Filter<Path> filter) {
        NBIOWalker.walk(null, p, v, filter, true);
    }

    public static void walk(Path root, Path p, PathVisitor v, DirectoryStream.Filter<Path> filter, boolean fullpath) {
        try {
            FileSystemProvider provider = p.getFileSystem().provider();
            DirectoryStream<Path> paths = provider.newDirectoryStream(p, r -> true);
            ArrayList<Path> pathlist = new ArrayList<Path>();
            for (Path path : paths) {
                pathlist.add(path);
            }
            for (Path path : pathlist) {
                if (fullpath && root != null) {
                    path = root.resolve(path);
                }
                if (path.getFileSystem().provider().readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).isDirectory()) {
                    v.preVisitDir(path);
                    NBIOWalker.walk(root, path, v, filter, fullpath);
                    v.postVisitDir(path);
                    continue;
                }
                if (!filter.accept(path)) continue;
                v.preVisitFile(path);
                v.visit(path);
                v.postVisitFile(path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface PathVisitor {
        public void visit(Path var1);

        default public void preVisitFile(Path path) {
        }

        default public void postVisitFile(Path path) {
        }

        default public void preVisitDir(Path path) {
        }

        default public void postVisitDir(Path path) {
        }
    }

    public static class CollectVisitor
    implements PathVisitor {
        private final List<Path> listing = new ArrayList<Path>();
        private final boolean collectFiles;
        private final boolean collectDirectories;

        public CollectVisitor(boolean collectFiles, boolean collectDirectories) {
            this.collectFiles = collectFiles;
            this.collectDirectories = collectDirectories;
        }

        public List<Path> get() {
            return this.listing;
        }

        @Override
        public void visit(Path p) {
        }

        @Override
        public void preVisitFile(Path path) {
            if (this.collectFiles) {
                this.listing.add(path);
            }
        }

        @Override
        public void preVisitDir(Path path) {
            if (this.collectDirectories) {
                this.listing.add(path);
            }
        }
    }

    public static class RegexFilter
    implements DirectoryStream.Filter<Path> {
        private final Pattern regex;

        public RegexFilter(String pattern, boolean rightglob) {
            this.regex = rightglob && !pattern.startsWith("^") && !pattern.startsWith(".") ? Pattern.compile(".*" + pattern) : Pattern.compile(pattern);
        }

        @Override
        public boolean accept(Path entry) throws IOException {
            String input = entry.toString();
            Matcher matcher = this.regex.matcher(input);
            boolean matches = matcher.matches();
            return matches;
        }

        public String toString() {
            return this.regex.toString();
        }
    }
}

