/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.markdown.aggregator;

import io.nosqlbench.nb.api.markdown.types.FrontMatterInfo;
import io.nosqlbench.nb.api.markdown.types.MarkdownInfo;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;

public class CompositeMarkdownInfo
implements MarkdownInfo {
    private List<MarkdownInfo> elements = new LinkedList<MarkdownInfo>();

    @Override
    public Path getPath() {
        return this.elements.get(0).getPath();
    }

    @Override
    public String getBody() {
        StringBuilder sb = new StringBuilder();
        for (MarkdownInfo element : this.elements) {
            sb.append(element.getBody());
        }
        return sb.toString();
    }

    @Override
    public FrontMatterInfo getFrontmatter() {
        return this.elements.get(0).getFrontmatter();
    }

    @Override
    public boolean hasAggregations() {
        return false;
    }

    @Override
    public MarkdownInfo withTopics(List<String> assigning) {
        MarkdownInfo leader = this.elements.get(0);
        leader = leader.withTopics(assigning);
        this.elements.set(0, leader);
        return this;
    }

    public <T extends MarkdownInfo> CompositeMarkdownInfo add(T element) {
        this.elements.add(element);
        return this;
    }
}

