/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.markdown.types;

import io.nosqlbench.nb.api.markdown.types.FrontMatterInfo;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public interface MarkdownInfo {
    public Path getPath();

    public String getBody();

    public FrontMatterInfo getFrontmatter();

    public boolean hasAggregations();

    default public boolean hasTopicGlobs() {
        return this.getTopicGlobs().size() > 0;
    }

    default public List<Pattern> getTopicGlobs() {
        return this.getFrontmatter().getTopics().stream().filter(t -> t.startsWith("^") || t.endsWith("$") || t.contains(".*") || t.contains(".+")).map(Pattern::compile).collect(Collectors.toList());
    }

    default public List<String> getTopics() {
        return this.getFrontmatter().getTopics().stream().filter(t -> !t.startsWith("^") && !t.endsWith("$") && !t.contains(".*") && !t.contains(".+")).collect(Collectors.toList());
    }

    default public boolean hasAggregators() {
        return this.getFrontmatter().getAggregations().size() > 0;
    }

    default public List<Pattern> getAggregators() {
        return this.getFrontmatter().getAggregations();
    }

    public MarkdownInfo withTopics(List<String> var1);
}

