/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.testutils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Result {
    private final long start;
    private final long end;
    private final long ops;
    private String description;

    public Result(String description, long start, long end, long ops) {
        this.description = description;
        this.start = start;
        this.end = end;
        this.ops = ops;
    }

    public String getDescription() {
        return this.description;
    }

    public long getTotalOps() {
        return this.ops;
    }

    public double getTimeSeconds() {
        return (double)(this.end - this.start) / 1.0E9;
    }

    public double getNsPerOp() {
        return (double)(this.end - this.start) / (double)this.ops;
    }

    public double getOpsPerSec() {
        return (double)this.getTotalOps() / this.getTimeSeconds();
    }

    public String toString() {
        long time_ns = this.end - this.start;
        return String.format("'%s': %d_ops %f_S %.3f_ops_s, %.0f_ns_op", this.description, this.ops, this.getTimeSeconds(), this.getOpsPerSec(), this.getNsPerOp());
    }

    public static List<String> toString(List<Result> results) {
        List ldesc = results.stream().map(Result::getDescription).collect(Collectors.toList());
        List lops = results.stream().map(r -> String.format("%d_ops", r.getTotalOps())).collect(Collectors.toList());
        List ltime_s = results.stream().map(r -> String.format("%f_S", r.getTimeSeconds())).collect(Collectors.toList());
        List lops_s = results.stream().map(r -> String.format("%.3f_ops_s", r.getOpsPerSec())).collect(Collectors.toList());
        List lns_op = results.stream().map(r -> String.format("%.0f_ns_op", r.getNsPerOp())).collect(Collectors.toList());
        int sizeof_ldesc = ldesc.stream().mapToInt(String::length).max().orElse(0);
        int sizeof_lops = lops.stream().mapToInt(String::length).max().orElse(0);
        int sizeof_ltime_s = ltime_s.stream().mapToInt(String::length).max().orElse(0);
        int sizeof_lops_s = lops_s.stream().mapToInt(String::length).max().orElse(0);
        int sizeof_lns_op = lns_op.stream().mapToInt(String::length).max().orElse(0);
        String fmt = "'%" + sizeof_ldesc + "s': %" + sizeof_lops + "s %" + sizeof_ltime_s + "s %" + sizeof_lops_s + "s %" + sizeof_lns_op + "s";
        ArrayList<String> rows = new ArrayList<String>(results.size());
        for (int i = 0; i < ldesc.size(); ++i) {
            String row = String.format(fmt, ldesc.get(i), lops.get(i), ltime_s.get(i), lops_s.get(i), lns_op.get(i));
            rows.add(row);
        }
        return rows;
    }

    public long getStartNanos() {
        return this.start;
    }

    public long getEndNanos() {
        return this.end;
    }
}

