/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.api.bindings;

import java.lang.reflect.TypeVariable;
import java.security.InvalidParameterException;
import java.util.function.DoubleFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongUnaryOperator;
import org.apache.commons.lang3.ClassUtils;

public class VirtDataFunctions {
    public static <F> F adapt(Object func, Class<F> type, Class<?> output, boolean truncate) {
        FuncType funcType = FuncType.valueOf(type);
        switch (funcType) {
            case LongUnaryOperator: {
                return (F)(truncate ? VirtDataFunctions.adaptLongUnaryOperator(func, output) : VirtDataFunctions.adaptLongUnaryOperatorStrict(func, output));
            }
            case DoubleUnaryOperator: {
                return truncate ? VirtDataFunctions.adaptDoubleUnaryOperator(func, output) : VirtDataFunctions.adaptDoubleUnaryOperatorStrict(func, output);
            }
            case IntUnaryOperator: {
                return truncate ? VirtDataFunctions.adaptIntUnaryOperator(func, output) : VirtDataFunctions.adaptIntUnaryOperatorStrict(func, output);
            }
            case DoubleFunction: {
                return truncate ? VirtDataFunctions.adaptDoubleFunction(func, output) : VirtDataFunctions.adaptDoubleFunctionStrict(func, output);
            }
            case LongFunction: {
                return (F)(truncate ? VirtDataFunctions.adaptLongFunction(func, output) : VirtDataFunctions.adaptLongFunctionStrict(func, output));
            }
            case IntFunction: {
                return truncate ? VirtDataFunctions.adaptIntFunction(func, output) : VirtDataFunctions.adaptIntFunction(func, output);
            }
            case Function: {
                return (F)(truncate ? VirtDataFunctions.adaptFunction(func, output) : VirtDataFunctions.adaptFunctionStrict(func, output));
            }
        }
        throw new RuntimeException("Unable to convert " + func.getClass().getCanonicalName() + " to " + type.getCanonicalName() + (truncate ? " WITH " : " WITHOUT ") + "truncation");
    }

    private static LongFunction<?> adaptLongFunctionStrict(Object func, Class<?> output) {
        FuncType isaType = FuncType.valueOf(func.getClass());
        switch (isaType) {
            case LongFunction: {
                LongFunction f1 = VirtDataFunctions.assertTypesAssignable(func, LongFunction.class, Object.class);
                return f1;
            }
            case LongUnaryOperator: {
                LongUnaryOperator f2 = VirtDataFunctions.assertTypesAssignable(func, LongUnaryOperator.class, new Class[0]);
                return f2::applyAsLong;
            }
            case Function: {
                Function f7 = VirtDataFunctions.assertTypesAssignable(func, Function.class, Long.class);
                return l -> f7.apply(l);
            }
        }
        throw new RuntimeException("Unable to convert " + func.getClass().getCanonicalName() + " to a " + LongUnaryOperator.class.getCanonicalName() + " since this would cause a narrowing conversion.");
    }

    private static Function<?, ?> adaptFunction(Object func, Class<?> output) {
        FuncType isaType = FuncType.valueOf(func.getClass());
        switch (isaType) {
            case LongFunction: {
                LongFunction f1 = (LongFunction)func;
                Function<Long, Object> rf1 = f1::apply;
                return rf1;
            }
            case LongUnaryOperator: {
                LongUnaryOperator f2 = (LongUnaryOperator)func;
                Function<Long, Long> rf2 = f2::applyAsLong;
                return rf2;
            }
            case IntFunction: {
                IntFunction f3 = (IntFunction)func;
                Function<Integer, Object> rf3 = f3::apply;
                return rf3;
            }
            case IntUnaryOperator: {
                IntUnaryOperator f4 = (IntUnaryOperator)func;
                Function<Integer, Object> rf4 = f4::applyAsInt;
                return rf4;
            }
            case DoubleFunction: {
                DoubleFunction f5 = (DoubleFunction)func;
                Function<Double, Object> rf5 = f5::apply;
                return rf5;
            }
            case DoubleUnaryOperator: {
                DoubleUnaryOperator f6 = (DoubleUnaryOperator)func;
                Function<Double, Object> rf6 = f6::applyAsDouble;
                return rf6;
            }
            case Function: {
                return (Function)func;
            }
        }
        throw new RuntimeException("Unable to map function:" + func);
    }

    private static <F> F adaptFunctionStrict(Object func, Class<?> output) {
        throw new RuntimeException("This must be implemented, now that it is used.");
    }

    private static <F> F adaptDoubleFunctionStrict(Object func, Class<?> output) {
        throw new RuntimeException("This must be implemented, now that it is used.");
    }

    private static <F> F adaptIntUnaryOperatorStrict(Object func, Class<?> output) {
        throw new RuntimeException("This must be implemented, now that it is used.");
    }

    private static <F> F adaptDoubleUnaryOperatorStrict(Object func, Class<?> output) {
        throw new RuntimeException("This must be implemented, now that it is used.");
    }

    private static LongUnaryOperator adaptLongUnaryOperatorStrict(Object func, Class<?> output) {
        FuncType isaType = FuncType.valueOf(func.getClass());
        switch (isaType) {
            case LongFunction: {
                LongFunction o2 = VirtDataFunctions.assertTypesAssignable(func, LongFunction.class, Long.TYPE);
                return o2::apply;
            }
            case LongUnaryOperator: {
                LongUnaryOperator o5 = VirtDataFunctions.assertTypesAssignable(func, LongUnaryOperator.class, new Class[0]);
                return o5;
            }
            case Function: {
                Function o7 = VirtDataFunctions.assertTypesAssignable(func, Function.class, Long.TYPE, Long.TYPE);
                return o7::apply;
            }
        }
        throw new RuntimeException("Unable to convert " + func.getClass().getCanonicalName() + " to a " + LongUnaryOperator.class.getCanonicalName() + " since this would cause a narrowing conversion.");
    }

    private static <F> F adaptIntFunction(Object func, Class<?> output) {
        throw new RuntimeException("This must be implemented, now that it is used.");
    }

    private static LongFunction<?> adaptLongFunction(Object func, Class<?> output) {
        FuncType isaType = FuncType.valueOf(func.getClass());
        switch (isaType) {
            case LongFunction: {
                LongFunction f1 = VirtDataFunctions.assertTypesAssignable(func, LongFunction.class, Object.class);
                return f1;
            }
            case LongUnaryOperator: {
                LongUnaryOperator f2 = VirtDataFunctions.assertTypesAssignable(func, LongUnaryOperator.class, new Class[0]);
                return f2::applyAsLong;
            }
            case IntFunction: {
                IntFunction f3 = VirtDataFunctions.assertTypesAssignable(func, IntFunction.class, new Class[0]);
                return l -> f3.apply((int)(l % Integer.MAX_VALUE));
            }
            case IntUnaryOperator: {
                IntUnaryOperator f4 = VirtDataFunctions.assertTypesAssignable(func, IntUnaryOperator.class, new Class[0]);
                return l -> f4.applyAsInt((int)(l % Integer.MAX_VALUE));
            }
            case DoubleFunction: {
                DoubleFunction f5 = VirtDataFunctions.assertTypesAssignable(func, DoubleFunction.class, new Class[0]);
                return f5::apply;
            }
            case DoubleUnaryOperator: {
                DoubleUnaryOperator f6 = VirtDataFunctions.assertTypesAssignable(func, DoubleUnaryOperator.class, new Class[0]);
                return f6::applyAsDouble;
            }
            case Function: {
                Function f7 = VirtDataFunctions.assertTypesAssignable(func, Function.class, new Class[0]);
                VirtDataFunctions.assertOutputAssignable(f7.apply(1L), output);
                return l -> f7.apply(l);
            }
        }
        throw new RuntimeException("Unable to convert " + func.getClass().getCanonicalName() + " to a " + LongUnaryOperator.class.getCanonicalName());
    }

    private static void assertOutputAssignable(Object result, Class<?> clazz) {
        if (!ClassUtils.isAssignable(result.getClass(), clazz, true)) {
            throw new InvalidParameterException("Unable to assign type of " + result.getClass().getCanonicalName() + " to " + clazz.getCanonicalName());
        }
    }

    private static <F> F adaptDoubleFunction(Object func, Class<?> output) {
        throw new RuntimeException("This must be implemented, now that it is used.");
    }

    private static <F> F adaptIntUnaryOperator(Object func, Class<?> output) {
        throw new RuntimeException("This must be implemented, now that it is used.");
    }

    private static <F> F adaptDoubleUnaryOperator(Object func, Class<?> output) {
        throw new RuntimeException("This must be implemented, now that it is used.");
    }

    private static LongUnaryOperator adaptLongUnaryOperator(Object func, Class<?> output) {
        FuncType isaType = FuncType.valueOf(func.getClass());
        switch (isaType) {
            case IntFunction: {
                IntFunction o1 = VirtDataFunctions.assertTypesAssignable(func, IntFunction.class, Long.TYPE);
                return l -> (Long)o1.apply((int)l % Integer.MAX_VALUE);
            }
            case LongFunction: {
                LongFunction o2 = VirtDataFunctions.assertTypesAssignable(func, LongFunction.class, Long.TYPE);
                return o2::apply;
            }
            case DoubleFunction: {
                DoubleFunction o3 = VirtDataFunctions.assertTypesAssignable(func, DoubleFunction.class, Long.TYPE);
                return o3::apply;
            }
            case IntUnaryOperator: {
                IntUnaryOperator o4 = VirtDataFunctions.assertTypesAssignable(func, IntUnaryOperator.class, new Class[0]);
                return l -> o4.applyAsInt((int)l % Integer.MAX_VALUE);
            }
            case LongUnaryOperator: {
                LongUnaryOperator o5 = VirtDataFunctions.assertTypesAssignable(func, LongUnaryOperator.class, new Class[0]);
                return o5;
            }
            case DoubleUnaryOperator: {
                DoubleUnaryOperator o6 = VirtDataFunctions.assertTypesAssignable(func, DoubleUnaryOperator.class, new Class[0]);
                return l -> (long)(o6.applyAsDouble(l) % 9.223372036854776E18);
            }
            case Function: {
                Function o7 = VirtDataFunctions.assertTypesAssignable(func, Function.class, Long.TYPE, Long.TYPE);
                return o7::apply;
            }
        }
        throw new InvalidParameterException("Unable to convert " + func.getClass().getCanonicalName() + " to a " + LongUnaryOperator.class.getCanonicalName());
    }

    private static <T> T assertTypesAssignable(Object base, Class<T> wantType, Class<?> ... clazzes) {
        if (!wantType.isAssignableFrom(base.getClass())) {
            throw new InvalidParameterException("Unable to assign " + wantType.getCanonicalName() + " from " + base.getClass().getCanonicalName());
        }
        TypeVariable<Class<?>>[] typeParameters = base.getClass().getTypeParameters();
        if (typeParameters.length > 0) {
            if (clazzes.length != typeParameters.length) {
                throw new InvalidParameterException("type parameter lengths are mismatched:" + clazzes.length + ", " + typeParameters.length);
            }
            for (int i = 0; i < clazzes.length; ++i) {
                Class<?> from = clazzes[i];
                TypeVariable<Class<?>> to = typeParameters[i];
                boolean assignableFrom = to.getGenericDeclaration().isAssignableFrom(from);
                if (assignableFrom) continue;
                throw new InvalidParameterException("Can not assign " + from.getCanonicalName() + " to " + to.getGenericDeclaration().getCanonicalName());
            }
        }
        return (T)base;
    }

    private static enum FuncType {
        LongToDoubleFunction(LongToDoubleFunction.class, Double.TYPE),
        LongFunction(LongFunction.class, Long.TYPE),
        LongUnaryOperator(LongUnaryOperator.class, Long.TYPE),
        IntFunction(IntFunction.class, Integer.TYPE),
        IntUnaryOperator(IntUnaryOperator.class, Integer.TYPE),
        DoubleFunction(DoubleFunction.class, Double.TYPE),
        DoubleUnaryOperator(DoubleUnaryOperator.class, Double.TYPE),
        Function(Function.class, Object.class);

        private final Class<?> functionClazz;
        private final Class<?> inputClazz;

        private FuncType(Class functionClazz, Class<?> example) {
            this.functionClazz = functionClazz;
            this.inputClazz = example;
        }

        public static FuncType valueOf(Class<?> clazz) {
            for (FuncType value : FuncType.values()) {
                if (!value.functionClazz.isAssignableFrom(clazz)) continue;
                return value;
            }
            throw new InvalidParameterException("No func type was found for " + clazz.getCanonicalName());
        }
    }
}

