/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.api.processors;

import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.processors.DocForFunc;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class FuncEnumerator {
    private final Types types;
    private final Elements elements;
    private final Filer filer;
    private DocForFunc model;
    private List<Listener> listeners = new ArrayList<Listener>();
    private String anchorPackage;
    private String anchorSimpleName;

    public FuncEnumerator(Types types, Elements elements, Filer filer) {
        this.types = types;
        this.elements = elements;
        this.filer = filer;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void onClass(String packageName, String simpleClassName, String classJavadoc) {
        if (this.model != null) {
            throw new RuntimeException("The DocModel was overwritten. Perhaps you are not calling flush() ?");
        }
        this.model = new DocForFunc();
        this.model.setPackageName(packageName);
        this.model.setClassName(simpleClassName);
        this.model.setClassJavadoc(classJavadoc);
    }

    public void onApplyTypes(String inType, String outType) {
        this.model.setInType(inType);
        this.model.setOutType(outType);
    }

    public void onConstructor(LinkedHashMap<String, String> args, String ctorJavaDoc, List<List<String>> examples) {
        this.model.addCtor(ctorJavaDoc, args, examples);
    }

    public void flush() {
        this.listeners.forEach(l -> l.onFunctionModel(this.model));
        this.model = null;
    }

    public void onCategories(Category[] categories) {
        this.model.addCategories(categories);
    }

    public static interface Listener {
        public void onFunctionModel(DocForFunc var1);
    }
}

