/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.core.bindings;

import io.nosqlbench.virtdata.core.bindings.Bindings;
import java.util.HashMap;
import java.util.Map;

public class BindingsCache {
    private final Bindings bindings;
    private Map<String, Object> valuesCache = new HashMap<String, Object>();

    public BindingsCache(Bindings bindings) {
        this.bindings = bindings;
    }

    public Object getField(String fieldName, long input) {
        Object value = this.valuesCache.computeIfAbsent(fieldName, k -> this.getFieldValue(fieldName, input));
        return value;
    }

    private Object getFieldValue(String fieldName, long coordinate) {
        int i = this.bindings.getTemplate().getBindPointNames().indexOf(fieldName);
        if (i < 0) {
            throw new RuntimeException("field name '" + fieldName + "' does not exist in bindings:" + this.bindings);
        }
        Object o = this.bindings.get(i, coordinate);
        return o;
    }

    public Map<String, Object> getCachedMap() {
        return this.valuesCache;
    }
}

