/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.core.bindings;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompatibilityFixups {
    private static final Logger logger = LogManager.getLogger(CompatibilityFixups.class);
    private static final Map<String, String> funcs = new HashMap<String, String>(){
        {
            this.put("log_normal", "LogNormal");
            this.put("normal", "Normal");
            this.put("levy", "Levy");
            this.put("nakagami", "Nakagami");
            this.put("exponential", "Exponential");
            this.put("logistic", "Logistic");
            this.put("laplace", "Laplace");
            this.put("cauchy", "Cauchy");
            this.put("f", "F");
            this.put("t", "T");
            this.put("weibull", "Weibull");
            this.put("chi_squared", "ChiSquared");
            this.put("gumbel", "Gumbel");
            this.put("beta", "Beta");
            this.put("pareto", "Pareto");
            this.put("gamma", "Gamma");
            this.put("uniform_real", "Uniform");
            this.put("uniform_integer", "Uniform");
            this.put("hypergeometric", "Hypergeometric");
            this.put("geometric", "Geometric");
            this.put("poisson", "Poisson");
            this.put("zipf", "Zipf");
            this.put("binomial", "Binomial");
            this.put("pascal", "Pascal");
        }
    };
    private static final String MAPTO = "mapto_";
    private static final String HASHTO = "hashto_";
    private static final String COMPUTE = "compute_";
    private static final String INTERPOLATE = "interpolate_";
    private static final Pattern oldcurve = Pattern.compile("(?<name>\\b[\\w_]+)(?<lparen>\\()(?<args>.*?)(?<rparen>\\))");
    private static final CompatibilityFixups instance = new CompatibilityFixups();

    public static String fixup(String spec) {
        String fixed = instance.fix(spec);
        if (!fixed.equals(spec)) {
            logger.warn(spec + "' was preprocessed to '" + fixed + "'. Please change to the new one to avoid this warning.");
        }
        return fixed;
    }

    public String fix(String spec) {
        Matcher matcher = oldcurve.matcher(spec);
        StringBuilder out = new StringBuilder(spec.length());
        int start = 0;
        while (matcher.find()) {
            out.append(spec.substring(start, matcher.start()));
            String replacement = this.fixCurveCall(matcher.group("name"), matcher.group("args"));
            out.append(replacement);
            start = matcher.end();
        }
        out.append(spec.substring(start));
        return out.toString();
    }

    private String fixCurveCall(String name, String args) {
        String nameReplacement;
        boolean map = false;
        boolean compute = false;
        if (name.contains(MAPTO)) {
            name = name.replaceAll(MAPTO, "");
            map = true;
        }
        if (name.contains(HASHTO)) {
            name = name.replaceAll(HASHTO, "");
            map = false;
        }
        if (name.contains(COMPUTE)) {
            name = name.replaceAll(COMPUTE, "");
            compute = true;
        }
        if (name.contains(INTERPOLATE)) {
            name = name.replaceAll(INTERPOLATE, "");
            compute = false;
        }
        if ((nameReplacement = funcs.get(name)) != null) {
            name = nameReplacement;
            args = map ? (String)args + ",'map'" : (String)args + ",'hash'";
            args = compute ? (String)args + ",'compute'" : (String)args + ",'interpolate'";
        }
        return name + "(" + (String)args + ")";
    }
}

