/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.core.bindings;

import io.nosqlbench.virtdata.core.bindings.Binder;
import io.nosqlbench.virtdata.core.bindings.Bindings;
import io.nosqlbench.virtdata.core.bindings.ValuesArrayBinder;

public class ContextualArrayBindings<C, R>
implements Binder<R> {
    private final C context;
    private Bindings bindings;
    private ValuesArrayBinder<C, R> valuesArrayBinder;

    public ContextualArrayBindings(Bindings bindings, C context, ValuesArrayBinder<C, R> valuesArrayBinder) {
        this.bindings = bindings;
        this.context = context;
        this.valuesArrayBinder = valuesArrayBinder;
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    public C getContext() {
        return this.context;
    }

    @Override
    public R bind(long value) {
        Object[] allGeneratedValues = this.bindings.getAll(value);
        try {
            return this.valuesArrayBinder.bindValues(this.context, allGeneratedValues);
        }
        catch (Exception e) {
            throw new RuntimeException("Binding error:" + this.bindings.getTemplate().toString(allGeneratedValues), e);
        }
    }
}

