/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.core.composers;

import io.nosqlbench.virtdata.core.bindings.FunctionType;
import io.nosqlbench.virtdata.core.bindings.ValueType;
import io.nosqlbench.virtdata.core.composers.ComposerForLongToDoubleFunction;
import io.nosqlbench.virtdata.core.composers.ComposerForLongToIntFunction;
import io.nosqlbench.virtdata.core.composers.ComposerForLongUnaryOperator;
import io.nosqlbench.virtdata.core.composers.FunctionComposer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComposerForLongFunction
implements FunctionComposer<LongFunction<?>> {
    private static final Logger logger = LogManager.getLogger(ComposerForLongFunction.class);
    private final LongFunction<?> inner;

    public ComposerForLongFunction(LongFunction<?> inner) {
        this.inner = inner;
    }

    @Override
    public Object getFunctionObject() {
        return this.inner;
    }

    @Override
    public FunctionComposer andThen(Object outer) {
        FunctionType functionType = FunctionType.valueOf(outer);
        Object outv = this.inner.apply(1L);
        ValueType itype = ValueType.valueOfAssignableClass(outv.getClass());
        switch (functionType) {
            case long_long: {
                switch (itype) {
                    case LONG: {
                        LongUnaryOperator f11 = l -> ((LongUnaryOperator)outer).applyAsLong((Long)this.inner.apply(l));
                        return new ComposerForLongUnaryOperator(f11);
                    }
                    case DOUBLE: {
                        LongUnaryOperator f12 = l -> ((LongUnaryOperator)outer).applyAsLong(((Double)this.inner.apply(l)).longValue());
                        return new ComposerForLongUnaryOperator(f12);
                    }
                    case INT: {
                        LongUnaryOperator f13 = l -> ((LongUnaryOperator)outer).applyAsLong(((Integer)this.inner.apply(l)).intValue());
                        return new ComposerForLongUnaryOperator(f13);
                    }
                }
                LongUnaryOperator f14 = l -> ((LongUnaryOperator)outer).applyAsLong(Double.valueOf(this.inner.apply(l).toString()).longValue());
                return new ComposerForLongUnaryOperator(f14);
            }
            case long_T: {
                switch (itype) {
                    case LONG: {
                        LongFunction<Object> f21 = l -> ((LongFunction)outer).apply((Long)this.inner.apply(l));
                        return new ComposerForLongFunction(f21);
                    }
                    case DOUBLE: {
                        LongFunction<Object> f22 = l -> ((LongFunction)outer).apply(((Double)this.inner.apply(l)).longValue());
                        return new ComposerForLongFunction(f22);
                    }
                    case INT: {
                        LongFunction<Object> f23 = l -> ((LongFunction)outer).apply(((Integer)this.inner.apply(l)).intValue());
                        return new ComposerForLongFunction(f23);
                    }
                }
                LongFunction<Object> f24 = l -> ((LongFunction)outer).apply(Double.valueOf(this.inner.apply(l).toString()).longValue());
                return new ComposerForLongFunction(f24);
            }
            case long_int: {
                switch (itype) {
                    case LONG: {
                        LongToIntFunction f31 = l -> ((LongToIntFunction)outer).applyAsInt((Long)this.inner.apply(l));
                        return new ComposerForLongToIntFunction(f31);
                    }
                    case DOUBLE: {
                        LongToIntFunction f32 = l -> ((LongToIntFunction)outer).applyAsInt(((Double)this.inner.apply(l)).longValue());
                        return new ComposerForLongToIntFunction(f32);
                    }
                    case INT: {
                        LongToIntFunction f33 = l -> ((LongToIntFunction)outer).applyAsInt(((Integer)this.inner.apply(l)).intValue());
                        return new ComposerForLongToIntFunction(f33);
                    }
                }
                LongToIntFunction f34 = l -> ((LongToIntFunction)outer).applyAsInt(Double.valueOf(this.inner.apply(l).toString()).longValue());
                return new ComposerForLongToIntFunction(f34);
            }
            case long_double: {
                switch (itype) {
                    case LONG: {
                        LongToDoubleFunction f41 = l -> ((LongToDoubleFunction)outer).applyAsDouble((Long)this.inner.apply(l));
                        return new ComposerForLongToDoubleFunction(f41);
                    }
                    case DOUBLE: {
                        LongToDoubleFunction f42 = l -> ((LongToDoubleFunction)outer).applyAsDouble(((Double)this.inner.apply(l)).longValue());
                        return new ComposerForLongToDoubleFunction(f42);
                    }
                    case INT: {
                        LongToDoubleFunction f43 = l -> ((LongToDoubleFunction)outer).applyAsDouble(((Integer)this.inner.apply(l)).intValue());
                        return new ComposerForLongToDoubleFunction(f43);
                    }
                }
                LongToDoubleFunction f44 = l -> ((LongToDoubleFunction)outer).applyAsDouble(Double.valueOf(this.inner.apply(l).toString()).longValue());
                return new ComposerForLongToDoubleFunction(f44);
            }
            case R_T: {
                LongFunction<Object> f5 = l -> ((Function)outer).apply(this.inner.apply(l));
                return new ComposerForLongFunction(f5);
            }
            case int_int: {
                switch (itype) {
                    case LONG: {
                        LongToIntFunction f61 = l -> ((IntUnaryOperator)outer).applyAsInt(((Long)this.inner.apply(l)).intValue());
                        return new ComposerForLongToIntFunction(f61);
                    }
                    case INT: {
                        LongToIntFunction f62 = l -> ((IntUnaryOperator)outer).applyAsInt((Integer)this.inner.apply(l));
                        return new ComposerForLongToIntFunction(f62);
                    }
                    case DOUBLE: {
                        LongToIntFunction f64 = l -> ((IntUnaryOperator)outer).applyAsInt(((Double)this.inner.apply(l)).intValue());
                        return new ComposerForLongToIntFunction(f64);
                    }
                }
                LongToIntFunction f63 = l -> ((IntUnaryOperator)outer).applyAsInt(Double.valueOf(this.inner.apply(l).toString()).intValue());
                return new ComposerForLongToIntFunction(f63);
            }
            case int_long: {
                switch (itype) {
                    case LONG: {
                        LongUnaryOperator f71 = l -> ((IntToLongFunction)outer).applyAsLong(((Long)this.inner.apply(l)).intValue());
                        return new ComposerForLongUnaryOperator(f71);
                    }
                    case INT: {
                        LongUnaryOperator f72 = l -> ((IntToLongFunction)outer).applyAsLong((Integer)this.inner.apply(l));
                        return new ComposerForLongUnaryOperator(f72);
                    }
                    case DOUBLE: {
                        LongUnaryOperator f73 = l -> ((IntToLongFunction)outer).applyAsLong(((Double)this.inner.apply(l)).intValue());
                        return new ComposerForLongUnaryOperator(f73);
                    }
                }
                LongUnaryOperator f74 = l -> ((IntToLongFunction)outer).applyAsLong(Double.valueOf(this.inner.apply(l).toString()).intValue());
                return new ComposerForLongUnaryOperator(f74);
            }
            case int_double: {
                switch (itype) {
                    case LONG: {
                        LongToDoubleFunction f81 = l -> ((IntToDoubleFunction)outer).applyAsDouble(((Long)this.inner.apply(l)).intValue());
                        return new ComposerForLongToDoubleFunction(f81);
                    }
                    case DOUBLE: {
                        LongToDoubleFunction f83 = l -> ((IntToDoubleFunction)outer).applyAsDouble(((Double)this.inner.apply(l)).intValue());
                        return new ComposerForLongToDoubleFunction(f83);
                    }
                    case INT: {
                        LongToDoubleFunction f82 = l -> ((IntToDoubleFunction)outer).applyAsDouble((Integer)this.inner.apply(l));
                        return new ComposerForLongToDoubleFunction(f82);
                    }
                }
                LongToDoubleFunction f84 = l -> ((IntToDoubleFunction)outer).applyAsDouble(Double.valueOf(this.inner.apply(l).toString()).intValue());
                return new ComposerForLongToDoubleFunction(f84);
            }
            case int_T: {
                switch (itype) {
                    case LONG: {
                        LongFunction<Object> f91 = l -> ((IntFunction)outer).apply(((Long)this.inner.apply(l)).intValue());
                        return new ComposerForLongFunction(f91);
                    }
                    case DOUBLE: {
                        LongFunction<Object> f92 = l -> ((IntFunction)outer).apply(((Double)this.inner.apply(l)).intValue());
                        return new ComposerForLongFunction(f92);
                    }
                    case INT: {
                        LongFunction<Object> f93 = l -> ((IntFunction)outer).apply((Integer)this.inner.apply(l));
                        return new ComposerForLongFunction(f93);
                    }
                }
                LongFunction<Object> f94 = l -> ((IntFunction)outer).apply(Double.valueOf(this.inner.apply(l).toString()).intValue());
                return new ComposerForLongFunction(f94);
            }
            case double_double: {
                switch (itype) {
                    case LONG: {
                        LongToDoubleFunction f101 = l -> ((DoubleUnaryOperator)outer).applyAsDouble(((Long)this.inner.apply(l)).longValue());
                        return new ComposerForLongToDoubleFunction(f101);
                    }
                    case DOUBLE: {
                        LongToDoubleFunction f102 = l -> ((DoubleUnaryOperator)outer).applyAsDouble((Double)this.inner.apply(l));
                        return new ComposerForLongToDoubleFunction(f102);
                    }
                    case INT: {
                        LongToDoubleFunction f103 = l -> ((DoubleUnaryOperator)outer).applyAsDouble(((Integer)this.inner.apply(l)).intValue());
                        return new ComposerForLongToDoubleFunction(f103);
                    }
                }
                LongToDoubleFunction f104 = l -> ((DoubleUnaryOperator)outer).applyAsDouble(Double.valueOf(this.inner.apply(l).toString()));
                return new ComposerForLongToDoubleFunction(f104);
            }
            case double_long: {
                switch (itype) {
                    case LONG: {
                        LongUnaryOperator f111 = l -> ((DoubleToLongFunction)outer).applyAsLong(((Long)this.inner.apply(l)).longValue());
                        return new ComposerForLongUnaryOperator(f111);
                    }
                    case INT: {
                        LongUnaryOperator f112 = l -> ((DoubleToLongFunction)outer).applyAsLong(((Integer)this.inner.apply(l)).intValue());
                        return new ComposerForLongUnaryOperator(f112);
                    }
                    case DOUBLE: {
                        LongUnaryOperator f113 = l -> ((DoubleToLongFunction)outer).applyAsLong((Double)this.inner.apply(l));
                        return new ComposerForLongUnaryOperator(f113);
                    }
                }
                LongUnaryOperator f114 = l -> ((DoubleToLongFunction)outer).applyAsLong(Double.valueOf(this.inner.apply(l).toString()));
                return new ComposerForLongUnaryOperator(f114);
            }
            case double_int: {
                switch (itype) {
                    case LONG: {
                        LongToIntFunction f121 = l -> ((DoubleToIntFunction)outer).applyAsInt(((Long)this.inner.apply(l)).longValue());
                        return new ComposerForLongToIntFunction(f121);
                    }
                    case INT: {
                        LongToIntFunction f122 = l -> ((DoubleToIntFunction)outer).applyAsInt(((Integer)this.inner.apply(l)).intValue());
                        return new ComposerForLongToIntFunction(f122);
                    }
                    case DOUBLE: {
                        LongToIntFunction f123 = l -> ((DoubleToIntFunction)outer).applyAsInt((Double)this.inner.apply(l));
                        return new ComposerForLongToIntFunction(f123);
                    }
                }
                LongToIntFunction f124 = l -> ((DoubleToIntFunction)outer).applyAsInt(Double.valueOf(this.inner.apply(l).toString()));
                return new ComposerForLongToIntFunction(f124);
            }
            case double_T: {
                switch (itype) {
                    case LONG: {
                        LongFunction<Object> f131 = l -> ((DoubleFunction)outer).apply(((Long)this.inner.apply(l)).longValue());
                        return new ComposerForLongFunction(f131);
                    }
                    case DOUBLE: {
                        LongFunction<Object> f133 = l -> ((DoubleFunction)outer).apply((Double)this.inner.apply(l));
                        return new ComposerForLongFunction(f133);
                    }
                    case INT: {
                        LongFunction<Object> f132 = l -> ((DoubleFunction)outer).apply(((Integer)this.inner.apply(l)).intValue());
                        return new ComposerForLongFunction(f132);
                    }
                }
                LongFunction<Object> f134 = l -> ((DoubleFunction)outer).apply(Double.valueOf(this.inner.apply(l).toString()));
                return new ComposerForLongFunction(f134);
            }
        }
        throw new RuntimeException(functionType + " is not recognized");
    }
}

