/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.core.composers;

import io.nosqlbench.virtdata.core.bindings.FunctionType;
import io.nosqlbench.virtdata.core.composers.ComposerForLongFunction;
import io.nosqlbench.virtdata.core.composers.ComposerForLongToDoubleFunction;
import io.nosqlbench.virtdata.core.composers.ComposerForLongUnaryOperator;
import io.nosqlbench.virtdata.core.composers.FunctionComposer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

public class ComposerForLongToIntFunction
implements FunctionComposer<LongToIntFunction> {
    private final LongToIntFunction inner;

    public ComposerForLongToIntFunction(LongToIntFunction inner) {
        this.inner = inner;
    }

    @Override
    public Object getFunctionObject() {
        return this.inner;
    }

    @Override
    public FunctionComposer andThen(Object outer) {
        FunctionType outerFunctionType = FunctionType.valueOf(outer);
        switch (outerFunctionType) {
            case long_long: {
                LongUnaryOperator f1 = l -> ((LongUnaryOperator)outer).applyAsLong(this.inner.applyAsInt(l));
                return new ComposerForLongUnaryOperator(f1);
            }
            case long_T: {
                LongFunction<Object> f2 = l -> ((LongFunction)outer).apply(this.inner.applyAsInt(l));
                return new ComposerForLongFunction(f2);
            }
            case long_int: {
                LongToIntFunction f3 = l -> ((LongToIntFunction)outer).applyAsInt(this.inner.applyAsInt(l));
                return new ComposerForLongToIntFunction(f3);
            }
            case long_double: {
                LongToDoubleFunction f4 = l -> ((LongToDoubleFunction)outer).applyAsDouble(this.inner.applyAsInt(l));
                return new ComposerForLongToDoubleFunction(f4);
            }
            case R_T: {
                LongFunction<Object> f5 = l -> ((Function)outer).apply(this.inner.applyAsInt(l));
                return new ComposerForLongFunction(f5);
            }
            case int_int: {
                LongToIntFunction f6 = l -> ((IntUnaryOperator)outer).applyAsInt(this.inner.applyAsInt(l));
                return new ComposerForLongToIntFunction(f6);
            }
            case int_long: {
                LongUnaryOperator f7 = l -> ((IntToLongFunction)outer).applyAsLong(this.inner.applyAsInt(l));
                return new ComposerForLongUnaryOperator(f7);
            }
            case int_double: {
                LongToDoubleFunction f8 = l -> ((IntToDoubleFunction)outer).applyAsDouble(this.inner.applyAsInt(l));
                return new ComposerForLongToDoubleFunction(f8);
            }
            case int_T: {
                LongFunction<Object> f9 = l -> ((IntFunction)outer).apply(this.inner.applyAsInt(l));
                return new ComposerForLongFunction(f9);
            }
            case double_double: {
                LongToDoubleFunction f10 = l -> ((DoubleUnaryOperator)outer).applyAsDouble(this.inner.applyAsInt(l));
                return new ComposerForLongToDoubleFunction(f10);
            }
            case double_long: {
                LongUnaryOperator f11 = l -> ((DoubleToLongFunction)outer).applyAsLong(this.inner.applyAsInt(l));
                return new ComposerForLongUnaryOperator(f11);
            }
            case double_int: {
                LongToIntFunction f12 = l -> ((DoubleToIntFunction)outer).applyAsInt(this.inner.applyAsInt(l));
                return new ComposerForLongToIntFunction(f12);
            }
            case double_T: {
                LongFunction<Object> f13 = l -> ((DoubleFunction)outer).apply(this.inner.applyAsInt(l));
                return new ComposerForLongFunction(f13);
            }
        }
        throw new RuntimeException(outerFunctionType + " is not recognized");
    }
}

