/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.core.stathelpers;

import io.nosqlbench.virtdata.library.basics.core.stathelpers.ElemProbD;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AliasElementSampler<T>
implements DoubleFunction<T> {
    private double[] biases;
    private T[] elements;
    private double slotCount;

    AliasElementSampler(double[] biases, T[] elements) {
        this.biases = biases;
        this.elements = elements;
    }

    AliasElementSampler(Collection<T> elements, Function<T, Double> weightFunction) {
        this(elements.stream().map(e -> new ElemProbD<Object>(e, (Double)weightFunction.apply(e))).collect(Collectors.toList()));
    }

    public AliasElementSampler(List<ElemProbD<T>> events) {
        int i;
        ElemProbD l;
        int size = events.size();
        LinkedList<ElemProbD> small = new LinkedList<ElemProbD>();
        LinkedList large = new LinkedList();
        ArrayList slots = new ArrayList();
        double sumProbability = events.stream().mapToDouble(ElemProbD::getProbability).sum();
        events = events.stream().map(e -> new ElemProbD(e.getElement(), e.getProbability() / sumProbability * (double)size)).collect(Collectors.toList());
        for (ElemProbD<T> event : events) {
            (event.getProbability() < 1.0 ? small : large).addLast(event);
        }
        while (small.peekFirst() != null && large.peekFirst() != null) {
            l = (ElemProbD)small.removeFirst();
            ElemProbD g = (ElemProbD)large.removeFirst();
            slots.add(new Slot(g.getElement(), l.getElement(), l.getProbability()));
            g.setProbability(g.getProbability() + l.getProbability() - 1.0);
            (g.getProbability() < 1.0 ? small : large).addLast(g);
        }
        while (large.peekFirst() != null) {
            ElemProbD g = (ElemProbD)large.removeFirst();
            slots.add(new Slot(g.getElement(), g.getElement(), 1.0));
        }
        while (small.peekFirst() != null) {
            l = (ElemProbD)small.removeFirst();
            slots.add(new Slot(l.getElement(), l.getElement(), 1.0));
        }
        if (slots.size() != size) {
            throw new RuntimeException("basis for average probability is incorrect, because only " + slots.size() + " slotCount of " + size + " were created.");
        }
        for (i = 0; i < slots.size(); ++i) {
            ((Slot)slots.get(i)).rescale(i, i + 1);
        }
        this.biases = new double[slots.size()];
        this.elements = new Object[this.biases.length * 2];
        for (i = 0; i < this.biases.length; ++i) {
            this.biases[i] = ((Slot)slots.get((int)i)).botProb;
            this.elements[i * 2] = ((Slot)slots.get((int)i)).botItx;
            this.elements[i * 2 + 1] = ((Slot)slots.get((int)i)).topIdx;
        }
        this.slotCount = this.biases.length;
    }

    @Override
    public T apply(double value) {
        double fractionlPoint = value * this.slotCount;
        int offsetPoint = (int)fractionlPoint;
        double divider = this.biases[offsetPoint];
        int index = fractionlPoint > divider ? (offsetPoint << 1) + 1 : offsetPoint << 1;
        T element = this.elements[index];
        return element;
    }

    private static class Slot<T> {
        public T topIdx;
        public T botItx;
        public double botProb;

        public Slot(T topIdx, T botItx, double botProb) {
            this.topIdx = topIdx;
            this.botItx = botItx;
            this.botProb = botProb;
        }

        public String toString() {
            return "top:" + this.topIdx + ", bot:" + this.botItx + ", botProb: " + this.botProb;
        }

        public Slot rescale(double min, double max) {
            this.botProb = min + this.botProb * (max - min);
            return this;
        }
    }

    public static interface Weighted {
        public double getWeight();
    }
}

