/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.core.stathelpers;

import io.nosqlbench.virtdata.library.basics.core.stathelpers.EvProbD;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.DoubleToIntFunction;
import java.util.stream.Collectors;

public class AliasSamplerDoubleInt
implements DoubleToIntFunction {
    private ByteBuffer stats;
    private double slotCount;
    private static int _r0 = 0;
    private static int _r1 = _r0 + 8;
    private static int _r2 = _r1 + 4;
    public static int RECORD_LEN = _r2 + 4;

    AliasSamplerDoubleInt(ByteBuffer stats) {
        this.stats = stats;
        if (stats.capacity() % RECORD_LEN != 0) {
            throw new RuntimeException("Misaligned ByteBuffer size, must be a multiple of " + RECORD_LEN);
        }
        this.slotCount = stats.capacity() / RECORD_LEN;
    }

    public AliasSamplerDoubleInt(List<EvProbD> events) {
        EvProbD l;
        int size = events.size();
        int[] alias = new int[events.size()];
        double[] prob = new double[events.size()];
        LinkedList<EvProbD> small = new LinkedList<EvProbD>();
        LinkedList large = new LinkedList();
        ArrayList<Slot> slots = new ArrayList<Slot>();
        double sumProbability = events.stream().mapToDouble(EvProbD::getProbability).sum();
        events = events.stream().map(e -> new EvProbD(e.getEventId(), e.getProbability() / sumProbability * (double)size)).collect(Collectors.toList());
        for (EvProbD event : events) {
            (event.getProbability() < 1.0 ? small : large).addLast(event);
        }
        while (small.peekFirst() != null && large.peekFirst() != null) {
            l = (EvProbD)small.removeFirst();
            EvProbD g = (EvProbD)large.removeFirst();
            slots.add(new Slot(g.getEventId(), l.getEventId(), l.getProbability()));
            g.setProbability(g.getProbability() + l.getProbability() - 1.0);
            (g.getProbability() < 1.0 ? small : large).addLast(g);
        }
        while (large.peekFirst() != null) {
            EvProbD g = (EvProbD)large.removeFirst();
            slots.add(new Slot(g.getEventId(), g.getEventId(), 1.0));
        }
        while (small.peekFirst() != null) {
            l = (EvProbD)small.removeFirst();
            slots.add(new Slot(l.getEventId(), l.getEventId(), 1.0));
        }
        if (slots.size() != size) {
            throw new RuntimeException("basis for average probability is incorrect, because only " + slots.size() + " slotCount of " + size + " were created.");
        }
        for (int i = 0; i < slots.size(); ++i) {
            ((Slot)slots.get(i)).rescale(i, i + 1);
        }
        this.stats = ByteBuffer.allocate(slots.size() * RECORD_LEN);
        for (Slot slot : slots) {
            this.stats.putDouble(slot.botProb);
            this.stats.putInt(slot.botItx);
            this.stats.putInt(slot.topIdx);
        }
        this.stats.flip();
        this.slotCount = this.stats.capacity() / RECORD_LEN;
    }

    @Override
    public int applyAsInt(double value) {
        int offsetPoint;
        double fractionlPoint = value * this.slotCount;
        double divider = this.stats.getDouble(offsetPoint = (int)fractionlPoint * RECORD_LEN);
        int selector = offsetPoint + (fractionlPoint > divider ? _r2 : _r1);
        int referentId = this.stats.getInt(selector);
        return referentId;
    }

    private static class Slot {
        public int topIdx;
        public int botItx;
        public double botProb;

        public Slot(int topIdx, int botItx, double botProb) {
            this.topIdx = topIdx;
            this.botItx = botItx;
            this.botProb = botProb;
        }

        public String toString() {
            return "top:" + this.topIdx + ", bot:" + this.botItx + ", botProb: " + this.botProb;
        }

        public Slot rescale(double min, double max) {
            this.botProb = min + this.botProb * (max - min);
            return this;
        }
    }
}

