/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_bigint;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.math.BigInteger;
import java.util.function.LongFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ThreadSafeMapper
@Categories(value={Category.conversion})
public class ModuloToBigInt
implements LongFunction<BigInteger> {
    private static final Logger logger = LogManager.getLogger(ModuloToBigInt.class);
    private final long modulo;

    public ModuloToBigInt() {
        this.modulo = Long.MAX_VALUE;
    }

    public ModuloToBigInt(long modulo) {
        this.modulo = modulo;
    }

    @Override
    public BigInteger apply(long value) {
        long ret = value % this.modulo & Long.MAX_VALUE;
        return BigInteger.valueOf(ret);
    }
}

