/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_collection;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

@Categories(value={Category.collections})
@ThreadSafeMapper
public class ListSizedStepped
implements LongFunction<List<Object>> {
    private final List<LongFunction<? extends Object>> valueFuncs;
    private final LongToIntFunction sizeFunc;

    @Example(value={"ListFunctions(NumberNameToString(),NumberNameToString())", "Create a list of ['one','one']"})
    public ListSizedStepped(LongToIntFunction sizeFunc, LongFunction<? extends Object> ... funcs) {
        this.sizeFunc = sizeFunc;
        this.valueFuncs = Arrays.asList(funcs);
    }

    @Example(value={"ListFunctions(NumberNameToString(),NumberNameToString())", "Create a list of ['one','one']"})
    public ListSizedStepped(LongToIntFunction sizeFunc, LongUnaryOperator ... funcs) {
        ArrayList<LongFunction<? extends Object>> building = new ArrayList<LongFunction<? extends Object>>(funcs.length);
        for (LongUnaryOperator func : funcs) {
            building.add(func::applyAsLong);
        }
        this.sizeFunc = sizeFunc;
        this.valueFuncs = building;
    }

    @Example(value={"ListFunctions(NumberNameToString(),NumberNameToString())", "Create a list of ['one','one']"})
    public ListSizedStepped(LongToIntFunction sizeFunc, Function<Long, Object> ... funcs) {
        ArrayList<LongFunction<? extends Object>> building = new ArrayList<LongFunction<? extends Object>>(funcs.length);
        for (Function<Long, Object> func : funcs) {
            building.add(func::apply);
        }
        this.sizeFunc = sizeFunc;
        this.valueFuncs = building;
    }

    @Override
    public List<Object> apply(long value) {
        int size = this.sizeFunc.applyAsInt(value);
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            int selector = Math.min(i, this.valueFuncs.size() - 1);
            LongFunction<? extends Object> func = this.valueFuncs.get(selector);
            list.add(func.apply((long)i + value));
        }
        return list;
    }
}

